/**
 * @author	shefali, Mei
 * @version	1.0
 * @desc	This the interface package for which a concrete class has to be defined by the various teams.
 * 			The java naming conventions are to be STRICTLY followed.
 **/
package gameinterface;
import java.awt.Color;
import java.awt.Point;
import piece.Move;
import piece.PiecePosition;

public interface GameInterface {

	//When your piece is moved to an empty position, the opponents gets this value.
	public static final int UNIDENTIFIED = -1;
	//When your piece moves to an empty position, you get this value.
	public static final int NONE = 0;
	public static final int MARSHAL = 1;
	public static final int GENERAL = 2; 
	public static final int COLONEL = 3;
	public static final int MAJOR = 4; 
	public static final int CAPTAIN = 5;
	public static final int LIEUTENANT = 6; 
	public static final int SERGEANT = 7;
	public static final int MINER = 8;
	public static final int SCOUT = 9;
	public static final int SPY = 10; 
	public static final int FLAG = 11; 
	public static final int BOMB = 12;
	/*
	 * @param	color - Color of your team. Will always be either red or blue
	 * @param	lake1 - lower left corner point for the Lake 1
	 * @param	lake2 - lower left corner point for the Lake 2
	 * @return	PiecePosition[] - This has to be an array of 40 ONLY. 
	 * @desc	If anything illegal is returned, it will result in endGame.
	 */
	PiecePosition[] setUpBoard (Color color, Point lake1, Point lake2);
	/*
	 * @param result: indicates whether your setup was successful or not.
	 */
	void setUpResult(boolean result);
	/*
	 * @param winner: the color of the winning team
	 */
	void endGame(Color winner);
	/*
	 * @return: Move you made. 
	 */
	Move makeMove();
	/*
	 * @param moveLegality: whether your move is legal or not
	 * @param pieceCode: what piece of the strikee was recovered as a result of your move.
	 * @desc any illegal move will result in endGame
	 */
	void strikerMoveResult(boolean moveLegality, int strikeePieceCode);
	/*
	 * @param pieceCode: what piece of striker moved.
	 * @param fromPiecePosition: From where it moved.
	 * @param toPiecePosition: to where it moved.
	 */
	void strikeeMoveResult(int strikerPieceCode, Point fromPiecePosition, Point toPiecePosition);

}
