/**
 * @author shefali, Mei
 * @version 1.0
 * This class represents the move being made. Any illegal move results in endGame.
 * All the legal piece codes are in GameInterface interface.
 * */
package piece;
import java.awt.Point;
public class Move {
		   
		private int pieceCode;
		private Point initialPosition;
		private Point finalPosition;
		/*
		 * @param pieceCode: pieceCode of the piece to move
		 * @param initialPosition: initial position of the piece being moved
		 * @param finalPosition: final position of the piece being moved.
		 */
		public Move(int pieceCode, Point initialPosition,Point finalPosition)
		{
			this.pieceCode = pieceCode;
			this.initialPosition = initialPosition;
			this.finalPosition = finalPosition;
		}
		/*
		 * @return: get the initial position of the piece being moved.
		 */		
		public Point getInitialPosition()
		{
			return initialPosition;
		}
		/*
		 * @return: get the final position of the piece being moved
		 */
		public Point getFinalPosition()
		{
			return finalPosition;
		}
		/*
		 * @return get the piece that is being moved.
		 */
		public int getPieceCode()
		{
			return pieceCode;
		}
}
