unit StructureInitializer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Buttons, Menus, Mask, DBCtrls, ExtCtrls, Convlib;

type
  TStructureInitializerForm = class(TForm)
    Edit_ncol: TEdit;
    Edit_nrow: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    CancelButton: TButton;
    FinishButton: TButton;
    NextButton: TButton;
    StringGrid_ncol: TStringGrid;
    StringGrid_nrow: TStringGrid;
    StructureInitializerMainMenu: TMainMenu;
    EditMenu: TMenuItem;
    ResetMenuItem: TMenuItem;
    SaveDialog: TSaveDialog;
    procedure CancelButtonClick(Sender: TObject);
    procedure ResetMenuItemClick(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure FinishButtonClick(Sender: TObject);
  private
    { Private declarations }
    function  GridValid(G : TStringGrid): Boolean;
  public
    { Public declarations }
    procedure BuildNewStructure;
  end;

var
  StructureInitializerForm: TStructureInitializerForm;

implementation

uses
  MainControl;

var
  ncol, nrow: Integer;
  FileToSave: TextFile;
  tmpPathName: string;

{$R *.DFM}

procedure TStructureInitializerForm.BuildNewStructure;
begin
{build a new structure}
  StructureInitializerForm.ResetMenuItemClick(StructureInitializerForm);
end;

procedure TStructureInitializerForm.CancelButtonClick(Sender: TObject);
begin
  StructureInitializerForm.Visible:=False;
  StructureInitializerForm.ResetMenuItemClick(StructureInitializerForm);
  MainControlForm.SetAllEnabledValues(True);
end;

procedure TStructureInitializerForm.ResetMenuItemClick(Sender: TObject);
begin
  With StructureInitializerForm do
  begin
  {Reset The Edits}
    Edit_ncol.Enabled:=True;
    Edit_nrow.Enabled:=True;
    Edit_ncol.Text:='';
    Edit_nrow.Text:='';
  {Reset The StringGrids}
    SetStringGrid(StringGrid_ncol, False, bsNone, 0, clGrayText);
    StringGrid_ncol.RowCount:=2;
    StringGrid_ncol.Cells[0,1]:='';
    StringGrid_ncol.Cells[1,1]:='';
    StringGrid_ncol.Cells[2,1]:='';
    StringGrid_ncol.Cells[0,0]:='Index';
    StringGrid_ncol.Cells[1,0]:='SubDivision';
    StringGrid_ncol.Cells[2,0]:='Length';
    SetStringGrid(StringGrid_nrow, False, bsNone, 0, clGrayText);
    StringGrid_nrow.RowCount:=2;
    StringGrid_nrow.Cells[0,1]:='';
    StringGrid_nrow.Cells[1,1]:='';
    StringGrid_nrow.Cells[2,1]:='';
    StringGrid_nrow.Cells[0,0]:='Index';
    StringGrid_nrow.Cells[1,0]:='SubDivision';
    StringGrid_nrow.Cells[2,0]:='Length';
  {Reset The Buttons}
    NextButton.Enabled:=True;
    FinishButton.Enabled:=False;
  end;{with}
end;

procedure TStructureInitializerForm.NextButtonClick(Sender: TObject);
var
  i: Integer;
begin
  with StructureInitializerForm do
  begin
    if StrCanToPosI(Edit_ncol.Text) and StrCanToPosI(Edit_nrow.Text) then begin
    {Set Edits and Buttons}
      Edit_ncol.Enabled:=False;
      Edit_nrow.Enabled:=False;
      NextButton.Enabled:=False;
      FinishButton.Enabled:=True;
    {Set StringGrid_ncol}
      ncol:= StrToInt(Edit_ncol.Text);
      StringGrid_ncol.RowCount:=1+ncol;
      for i:= 1 to ncol do begin
        StringGrid_ncol.Rows[i].CommaText:=',1,1';
        StringGrid_ncol.Cells[0,i]:=IntToStr(i);
      end;
      SetStringGrid(StringGrid_ncol, True, bsSingle, 1, clWindowText);
    {Set StringGrid_nrow}
      nrow:= StrToInt(Edit_nrow.Text);
      StringGrid_nrow.RowCount:=1+StrToInt(Edit_nrow.Text);
      for i:= 1 to nrow do begin
        StringGrid_nrow.Rows[i].CommaText:=',1,1';
        StringGrid_nrow.Cells[0,i]:=IntToStr(i);
      end;
      SetStringGrid(StringGrid_nrow, True, bsSingle, 1, clWindowText);
    end else begin
      MessageDlg('ncol and nrow require positive integers',
                  mtInformation, [mbOk], 0);
    end;{if}
  end;{with}
end; {procedure}

function TStructureInitializerForm.GridValid(G: TStringGrid): Boolean;
{Post: ncol and nrow are assign values correctly
       G is StringGrid_ncol or StringGrid_nrow}
var i,n: Integer;
begin
  n:=G.RowCount-1;
  GridValid:=True;
  for i:= 1 to n do begin
    if not (StrCanToPosI(G.Cells[1,i]) and StrCanToPosF(G.Cells[2,i])) then
    begin
      GridValid:=False;
    end;{if}
  end;{for}
end;{function GridValid}

procedure TStructureInitializerForm.FinishButtonClick(Sender: TObject);
{Post: It is an assumption that ncol and nrow have been assigned value
       correctly}
var
  pass: Boolean;
  i: Integer;
begin
with StructureInitializerForm do begin
  pass := GridValid(StringGrid_ncol) and GridValid(StringGrid_nrow);
  if pass then
  begin
    if Savedialog.Execute then
    begin
     //become invisible first
      Visible:=False;
     //save files
      AssignFile(FileToSave, Savedialog.FileName);
      Rewrite(FileToSave);
      Writeln(FileToSave, Edit_ncol.Text,' ', Edit_nrow.Text);
      CloseFile(FileToSave);
      tmpPathName:=Copy(Savedialog.FileName,1,length(Savedialog.FileName)-4);
      AssignFile(FileToSave, tmpPathName+'.div');
      Rewrite(FileToSave);
      for i:= 1 to ncol do
        write(FileToSave, StringGrid_ncol.Cells[1,i],
              ' ',StringGrid_ncol.Cells[2,i],' ');
      writeln(FileToSave);
      for i:= 1 to nrow do
        write(FileToSave, StringGrid_nrow.Cells[1,i],
              ' ',StringGrid_nrow.Cells[2,i],' ');
      CloseFile(FileToSave);
     //go back to MainControl
      MainControlForm.SetAllEnabledValues(True);
    end{if Savedialog.Execute}
  end else begin
    MessageDlg('Invalid Input to Grids',
                mtInformation, [mbOk], 0);
  end;{if pass}
end{with}
end;{procedure}

end.
