program StructureEditor;

uses
  Forms,
  MainControl in 'MainControl.pas' {MainControlForm},
  ConvLib in 'ConvLib.pas',
  GridBlockViewer in 'GridBlockViewer.pas' {GridBlockViewerForm},
  LinearDivisionViewer in 'LinearDivisionViewer.pas' {LinearDivisionViewerForm},
  NodeViewer in 'NodeViewer.pas' {NodeViewerForm},
  PieceViewer in 'PieceViewer.pas' {PieceViewerForm},
  StructureInitializer in 'StructureInitializer.pas' {StructureInitializerForm},
  MainViewer in 'MainViewer.pas' {MainViewerForm},
  MaterialViewer in 'MaterialViewer.pas' {MaterialViewerForm},
  BoundaryViewer in 'BoundaryViewer.pas' {BoundaryViewerForm},
  BlockInfoViewer in 'BlockInfoViewer.pas' {BlockInfoViewerForm},
  AnalyzeLib in 'AnalyzeLib.pas',
  AnalyzeResultViewer in 'AnalyzeResultViewer.pas' {AnalyzeResultViewerForm};

{$R *.RES}

begin
  Application.Initialize;
  Application.CreateForm(TMainControlForm, MainControlForm);
  Application.CreateForm(TBlockInfoViewerForm, BlockInfoViewerForm);
  Application.CreateForm(TGridBlockViewerForm, GridBlockViewerForm);
  Application.CreateForm(TLinearDivisionViewerForm, LinearDivisionViewerForm);
  Application.CreateForm(TNodeViewerForm, NodeViewerForm);
  Application.CreateForm(TPieceViewerForm, PieceViewerForm);
  Application.CreateForm(TStructureInitializerForm, StructureInitializerForm);
  Application.CreateForm(TMainViewerForm, MainViewerForm);
  Application.CreateForm(TMaterialViewerForm, MaterialViewerForm);
  Application.CreateForm(TBoundaryViewerForm, BoundaryViewerForm);
  Application.CreateForm(TAnalyzeResultViewerForm, AnalyzeResultViewerForm);
  ConvLib.SetDefaultParameters(1,1,1,1,1,1);

 {to initialize the visibility of each viewer}
  MainControlForm.InitDefaultVisibility;
  MainControlForm.ApplyVisibility;

 {to initialize other GUI state variables}
  MainControlForm.StructureLoaded:= False;
  MainControlForm.StructureSaved:= True;

 {to initiaialize all GUIs}
  MainControlForm.ReloadAll(MainControlForm); 

  Application.Run;

end.                  
