unit PieceViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Menus, Grids, StdCtrls, ConvLib;

type
  TPieceViewerForm = class(TForm)
    PieceViewerPageControl: TPageControl;
    PieceUM: TTabSheet;
    PieceDM: TTabSheet;
    PieceViewerMainMenu: TMainMenu;
    ViewMenu: TMenuItem;
    ReloadMenuItem: TMenuItem;
    GridUM: TStringGrid;
    GridDM: TStringGrid;
    CancelDismissButton: TButton;
    ModifyButton: TButton;
    OKButton: TButton;
    CancelButton: TButton;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure ModifyButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure CancelDismissButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PieceViewerForm: TPieceViewerForm;

implementation

uses
  MainControl;
  
{$R *.DFM}

procedure ReloadUM;
{assumption: MainControlForm.StructureLoaded=True}
var i: Integer;
begin
with PieceViewerForm do begin
 //disable the controls which should be disabled
  OKButton.Enabled:= False;
  CancelButton.Enabled:= False;
 //set up the grid
  SetStringGrid(GridUM,False,bsSingle,1,clGrayText);
  GridUM.RowCount:= 1+length(UBlockM);
  GridUM.Rows[0].CommaText:='Index,Material';
  for i:= 1 to length(UBlockM) do begin
    GridUM.Cells[0,i]:= IntToStr(i);
    GridUM.Cells[1,i]:= IntToStr(UBlockM[i-1].mtlIndex);
  end;{for}
 //enable the controls which should be enabled
  PieceViewerForm.ModifyButton.Enabled:= True;
end;{with}
end;{procedure ReloadUM}

procedure ReloadDM;
{assumption: MainControlForm.StructureLoaded=True}
var i: Integer;
begin
with PieceViewerForm do begin
  if length(DBlockM)>0 then begin
    SetStringGrid(GridDM,False,bsSingle,1,clGrayText);
    GridDM.RowCount:= 1+length(DBlockM);
    GridDM.Rows[0].CommaText:='Index,Grid_Block';
    for i:= 1 to length(DBlockM) do begin
      GridDM.Cells[0,i]:=IntToStr(i);
      GridDM.Cells[1,i]:= IntToStr(DBlockM[i-1]);
    end;{for}
  end else begin
    SetStringGrid(GridDM,False,bsSingle,1,clGrayText);
    GridDM.RowCount:= 2;
    GridDM.Rows[1].CommaText:='';
  end;{if}
end;{with}
end;{procedure ReloadDM}

procedure TPieceViewerForm.ReloadMenuItemClick(Sender: TObject);
begin
MainControlForm.SetAllEnabledValues(False);
  if MainControlForm.StructureLoaded then begin
   //disable the controls which should be disabled
    PieceViewerForm.ReloadMenuItem.Enabled:= True;
   //set up each page
    ReloadUM;
    ReloadDM;
    //Reload[UE/US/DE/DS] are dropped at Beta1p1 version
  end else begin
    PieceViewerForm.ReloadMenuItem.Enabled:=False;
    PieceViewerForm.ModifyButton.Enabled:=False;
    PieceViewerForm.OKButton.Enabled:=False;
    PieceViewerForm.CancelButton.Enabled:=False;
    SetStringGrid(GridUM,False,bsSingle,0,clGrayText);
    SetStringGrid(GridDM,False,bsSingle,0,clGrayText);
  end;{if}
MainControlForm.SetAllEnabledValues(True);
end;{procedure}

procedure TPieceViewerForm.ModifyButtonClick(Sender: TObject);
begin
  if ModifyingMode then begin
    ShowMessage('Please finish the current editing');
    exit;
  end; {if ModifyingMode}
  if AnalyzingMode then begin
    ShowMessage('Structure cannot be modified in Analyze Mode');
    exit;
  end; {if AnalyzingMode}
  //disable the controls which should be disabled
   PieceViewerForm.ModifyButton.Enabled:= False;
   PieceViewerForm.ReloadMenuItem.Enabled:= False;
  //set up the grid
   SetStringGrid(GridUM,True,bsSingle,1,clWindowText);
  //set the GUI mode
   MainControlForm.GoModifyingMode;
  //change message
   MainControlForm.MessageLabel.Caption:=
     'Message: Editing pieces';
  //enable the controls which should be enabled
   PieceViewerForm.CancelButton.Enabled:= True;
   PieceViewerForm.OKButton.Enabled:= True;
end;

procedure TPieceViewerForm.CancelButtonClick(Sender: TObject);
begin
  PieceViewerForm.ReloadMenuItemClick(Sender);
  MainControlForm.LeaveModifyingMode;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;{procedure}

function ubmGridValid(G: TStringGrid): Boolean;
var i: Integer;
begin
  ubmGridValid:= True;
  for i:= 1 to (G.RowCount-1) do begin
    if (not StrCanToNonNegI(G.Cells[1,i])) then begin
      ubmGridValid:= False;
    end;{if}
  end;{for}
end;{function ubmGridValid}


procedure TPieceViewerForm.OKButtonClick(Sender: TObject);
var i: Integer;
begin
  if ubmGridValid(GridUM) then begin
    //disable the controls which should be disabled
     PieceViewerForm.OKButton.Enabled:= False;
     PieceViewerForm.CancelButton.Enabled:= False;
     PieceViewerForm.GridUM.Options:=
     PieceViewerForm.GridUM.Options-[goEditing,goAlwaysShowEditor];
    //update UBlockM
     for i:= 1 to length(UBlockM) do begin
       UBlockM[i-1].mtlIndex:= StrToInt(GridUM.Cells[1,i]);
     end;{for i}
    //regenerate the structure data
     PostLoadMakeAction;
    //refresh all GUIs
     MainControlForm.ReloadAll(PieceViewerForm);
     ReloadDM;
    //Change GUI state variables
     MainControlForm.StructureSaved:= False;
    //enable the controls which should be enabled
     PieceViewerForm.ReloadMenuItem.Enabled:= True;
     PieceViewerForm.ModifyButton.Enabled:= True;
    //lead to boundary viewer
     MainControlForm.LeaveModifyingMode; {necessary}
     MainControlForm.ForceToModifyBoundary; 
  end else begin
     ShowMessage('Invalid Input');
     PieceViewerForm.Enabled:= True;
  end;{if}
end;{procedure}

procedure TPieceViewerForm.CancelDismissButtonClick(Sender: TObject);
begin
  PieceViewerForm.ReloadMenuItemClick(Sender);
  MainControlForm.LeaveModifyingMode;
 //make PieceViewer invisible 
  PieceViewerVisible:= False;
  MainControlForm.PieceViewerMenuItem.Checked:= False;
  PieceViewerForm.Visible:= False;
 //change message
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;

procedure TPieceViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  if (not PieceViewerForm.ModifyButton.Enabled)
  and (MainControlForm.StructureLoaded) then begin
    MessageDlg('please finish editing', mtInformation,
               [mbOK], 0);
  end else begin
    PieceViewerVisible:= False;
    MainControlForm.PieceViewerMenuItem.Checked:= False;
    PieceViewerForm.Visible:= False;
  end;{if}
end;{procedure}

end.
