unit NodeViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ComCtrls, StdCtrls, Menus, ConvLib;

type
  TNodeViewerForm = class(TForm)
    PageControl: TPageControl;
    UMPage: TTabSheet;
    ModifyButton: TButton;
    ShapedXEdit: TEdit;
    ShapedYEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OKButton: TButton;
    CancelButton: TButton;
    NodeViewerMainMenu: TMainMenu;
    ViewMenu: TMenuItem;
    ReloadMenuItem: TMenuItem;
    StringGrid_UM: TStringGrid;
    CancelDismissButton: TButton;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ModifyButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure CancelDismissButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  NodeViewerForm: TNodeViewerForm;

implementation

uses
  MainControl;
  
{$R *.DFM}
procedure ReloadUM;
var i: Integer;
begin
with NodeViewerForm do begin
 if MainControlForm.StructureLoaded then begin
     StringGrid_UM.RowCount:=length(UNodeM)+1;
     SetStringGrid(StringGrid_UM, False, bsSingle, 1, clGrayText);
     StringGrid_UM.Rows[0].CommaText:=
       'Index,X,Y';
     for i:= 1 to length(UNodeM) do begin
       StringGrid_UM.Cells[0,i]:=IntToStr(i);
       StringGrid_UM.Cells[1,i]:=FloatToStr(UNodeM[i-1].ShapedX);
       StringGrid_UM.Cells[2,i]:=FloatToStr(UNodeM[i-1].ShapedY);
     end;{for}
    //Reset buttons and edits
     CancelButton.Enabled:=False;
     OKButton.Enabled:=False;
     ShapedXEdit.Enabled:=False;
     ShapedXEdit.Text:= '';
     ShapedYEdit.Enabled:=False;
     ShapedYEdit.Text:= '';
     Label1.Enabled:= False;
     Label2.Enabled:= False;
     ModifyButton.Enabled:=True;
     ReloadMenuItem.Enabled:= True;
 end else begin
     SetStringGrid(StringGrid_UM, False, bsSingle, 0, clGrayText);
     ReloadMenuItem.Enabled:= False;
     CancelButton.Enabled:= False;
     OKButton.Enabled:= False;
     ShapedXEdit.Enabled:= False;
     ShapedYEdit.Enabled:= False;
     Label1.Enabled:= False;
     Label2.Enabled:= False;
     ModifyButton.Enabled:=False;
 end{if StructureLoaded }
end;{with}
end;{procedure ReloadUM}

procedure TNodeViewerForm.ReloadMenuItemClick(Sender: TObject);
begin
  MainControlForm.SetAllEnabledValues(False);
  ReloadUM;
 // note: Reload[UE/US/DM/DE/DS] are deleted
 //at Beta1p1 version
  MainControlForm.SetAllEnabledValues(True);
end; {procedure}

procedure TNodeViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  if NodeViewerForm.ModifyButton.Enabled
  or (not MainControlForm.StructureLoaded) then begin
    NodeViewerVisible:= False;
    MainControlForm.NodeViewerMenuItem.Checked:= False;
    NodeViewerForm.Visible:= False;
  end else begin
    MessageDlg('Please finish editing before closeing',
               mtInformation, [mbOK], 0);
  end;{if}
end;

procedure TNodeViewerForm.ModifyButtonClick(Sender: TObject);
begin
if ModifyingMode then begin
  ShowMessage('Please finish the current editing');
  exit;
end;{if ModifyingMode}
  if AnalyzingMode then begin
    ShowMessage('Structure cannot be modified in Analyzing mode');
    exit;
  end;{if AnalyzingMode}
with NodeViewerForm do begin
  ModifyButton.Enabled:= False;
  ReloadMenuItem.Enabled:= False;
  Label1.Enabled:= True;
  Label2.Enabled:= True;
  ShapedXEdit.Text:= StringGrid_UM.Cells[1,StringGrid_UM.Row];
  ShapedYEdit.Text:= StringGrid_UM.Cells[2,StringGrid_UM.Row];
  ShapedXEdit.Enabled:= True;
  ShapedYEdit.Enabled:= True;
  OKButton.Enabled:= True;
  CancelButton.Enabled:= True;
end; {with}
MainControlForm.MessageLabel.Caption:=
    'Message: Editing nodes';
MainControlForm.GoModifyingMode;
end; {procedure}

procedure TNodeViewerForm.OKButtonClick(Sender: TObject);
begin
  if ( StrCanToFloat(ShapedXEdit.Text)
  and StrCanToFloat(ShapedYEdit.Text)  )then begin
   //Disable controls which should be disabled
    NodeViewerForm.OKButton.Enabled:=False;
    NodeViewerForm.CancelButton.Enabled:=False;
    NodeViewerForm.ShapedXEdit.Enabled:=False;
    NodeViewerForm.ShapedYEdit.Enabled:=False;
    NodeViewerForm.Label1.Enabled:=False;
    NodeViewerForm.Label2.Enabled:=False;
   //Data manipulation
    StringGrid_UM.Cells[1,StringGrid_UM.Row]:= ShapedXEdit.Text;
    UNodeM[StringGrid_UM.Row-1].ShapedX:=
                               StrToFloat(ShapedXEdit.Text);
    StringGrid_UM.Cells[2,StringGrid_UM.Row]:= ShapedYEdit.Text;
    UNodeM[StringGrid_UM.Row-1].ShapedY:=
                               StrToFloat(ShapedYEdit.Text);
    PostLoadMakeAction;
   //Reload all forms except NodeViewerForm
    MainControlForm.ReloadAll(NodeViewerForm);
    NodeViewerForm.ReloadMenuItemClick(NodeViewerForm);
   //Change GUI state variable
    MainControlForm.StructureSaved:= False;
   //reset the text edits
    NodeViewerForm.ShapedXEdit.Text:='';
    NodeViewerForm.ShapedYEdit.Text:='';
   //Enable the controls that should be enabled
    NodeViewerForm.ReloadMenuItem.Enabled:=True;
    NodeViewerForm.ModifyButton.Enabled:=True;
   //change GUI mode
    MainControlForm.LeaveModifyingMode;
   //change message
    MainControlForm.MessageLabel.Caption:=
      'Message:';
  end else begin
    MessageDlg('Invalid input', mtInformation, [mbOK], 0);
  end;{if}
end;{procedure}

procedure TNodeViewerForm.CancelButtonClick(Sender: TObject);
begin
  NodeViewerForm.ReloadMenuItemClick(NodeViewerForm);
  MainControlForm.LeaveModifyingMode;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;

procedure TNodeViewerForm.CancelDismissButtonClick(Sender: TObject);
begin
  NodeViewerForm.ReloadMenuItemClick(NodeViewerForm);
  MainControlForm.LeaveModifyingMode;
  NodeViewerVisible:= False;
  MainControlForm.NodeViewerMenuItem.Checked:= False;
  NodeViewerForm.Visible:= False;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;

end.
