unit MaterialViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Menus, ConvLib;

type
  TMaterialViewerForm = class(TForm)
    StringGrid_mtl: TStringGrid;
    ModifyButton: TButton;
    AddButton: TButton;
    DeleteButton: TButton;
    OKButton: TButton;
    CancelButton: TButton;
    MaterialViewerMainMenu: TMainMenu;
    ViewMenu: TMenuItem;
    ReloadMenuItem: TMenuItem;
    CancelDismissButton: TButton;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure ModifyButtonClick(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure CancelDismissButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MaterialViewerForm: TMaterialViewerForm;

implementation

uses
  MainControl;

{$R *.DFM}

procedure TMaterialViewerForm.ReloadMenuItemClick(Sender: TObject);
var i: Integer;
begin
  if MainControlForm.StructureLoaded then begin
   //Disable the controls should be disabled
    MaterialViewerForm.AddButton.Enabled:= False;
    MaterialViewerForm.DeleteButton.Enabled:=False;
    MaterialViewerForm.OKButton.Enabled:=False;
    MaterialViewerForm.CancelButton.Enabled:=False;
   //set up the grid
    SetStringGrid(StringGrid_mtl, False, bsSingle, 1, clGrayText);
    StringGrid_mtl.Rows[0].CommaText:=
                           'Index,Elastic,PossionRate,UnitWeight';
    StringGrid_mtl.RowCount:= 1+length(Material);
    for i:= 1 to length(Material) do begin
      StringGrid_mtl.Cells[0,i]:= FloatToStr(i);
      StringGrid_mtl.Cells[1,i]:= FloatToStr(Material[i-1].Elastic);
      StringGrid_mtl.Cells[2,i]:= FloatToStr(Material[i-1].PossionRate);
      StringGrid_mtl.Cells[3,i]:= FloatToStr(Material[i-1].UnitWeight);
    end;{for}
   //Enable what should be enable
    MaterialViewerForm.ReloadMenuItem.Enabled:= True;   
    MaterialViewerForm.ModifyButton.Enabled:= True;
  end else begin
    MaterialViewerForm.ReloadMenuItem.Enabled:=False;
    MaterialViewerForm.AddButton.Enabled:=False;
    MaterialViewerForm.DeleteButton.Enabled:=False;
    MaterialViewerForm.ModifyButton.Enabled:=False;
    MaterialViewerForm.OKButton.Enabled:=False;
    MaterialViewerForm.CancelButton.Enabled:=False;
    SetStringGrid(StringGrid_mtl, False, bsSingle, 0, clGrayText);
  end;{if}
end;{procedure}

procedure TMaterialViewerForm.ModifyButtonClick(Sender: TObject);
{assumption: structure loaded}
begin
if ModifyingMode then begin
  ShowMessage('Please finish current editing');
  exit;
end;{if ModifyingMode}
if AnalyzingMode then begin
  ShowMessage('Structure cannot be modified in Analyzing Mode');
  exit;
end;{if AnalyzingMode}
  //disable the buttons which should be disable
   MaterialViewerForm.ModifyButton.Enabled:= False;
   MaterialViewerForm.ReloadMenuItem.Enabled:= False;
  //set up the grid
   SetStringGrid(StringGrid_mtl, True, bsSingle, 1, clWindowText);
  //set GUI mode
   MainControlForm.GoModifyingMode;
  //enable the buttons which should be enable
   MaterialViewerForm.AddButton.Enabled:= True;
   MaterialViewerForm.DeleteButton.Enabled:= True;
   MaterialViewerForm.OKButton.Enabled:= True;
   MaterialViewerForm.CancelButton.Enabled:= True;
  //change message
   MainControlForm.MessageLabel.Caption:=
     'Message: Editing Materials';
end;

procedure TMaterialViewerForm.AddButtonClick(Sender: TObject);
{assumption: "Modify" button have been click}
var
  i, SelectedLine: Integer;
begin
  SelectedLine:= StringGrid_mtl.Row;
  StringGrid_mtl.RowCount:= 1+StringGrid_mtl.RowCount;
  for i:= (StringGrid_mtl.RowCount-1)
      downto (SelectedLine+1) do begin
    StringGrid_mtl.Cells[0,i]:= IntToStr(i);
    StringGrid_mtl.Cells[1,i]:= StringGrid_mtl.Cells[1,i-1];
    StringGrid_mtl.Cells[2,i]:= StringGrid_mtl.Cells[2,i-1];
    StringGrid_mtl.Cells[3,i]:= StringGrid_mtl.Cells[3,i-1];
  end;{for}
  StringGrid_mtl.Cells[0,SelectedLine]:= IntToStr(SelectedLine);
  StringGrid_mtl.Cells[1,SelectedLine]:= '';
  StringGrid_mtl.Cells[2,SelectedLine]:= '';
  StringGrid_mtl.Cells[3,SelectedLine]:= '';
end;

procedure TMaterialViewerForm.DeleteButtonClick(Sender: TObject);
var
  i, SelectedLine: Integer;
begin
  SelectedLine:= StringGrid_mtl.Row;
  if StringGrid_mtl.RowCount>=3 then begin
    for i:= SelectedLine to (StringGrid_mtl.RowCount-2) do begin
      StringGrid_mtl.Cells[0,i]:= IntToStr(i);
      StringGrid_mtl.Cells[1,i]:= StringGrid_mtl.Cells[1,i+1];
      StringGrid_mtl.Cells[2,i]:= StringGrid_mtl.Cells[2,i+1];
      StringGrid_mtl.Cells[3,i]:= StringGrid_mtl.Cells[3,i+1];
    end;{for}
    StringGrid_mtl.RowCount:= StringGrid_mtl.RowCount-1;
  end else begin
    MessageDlg('There must be at least one material', mtInformation,
               [mbOK], 0);
  end;{if}
end;{procedure}

procedure TMaterialViewerForm.CancelButtonClick(Sender: TObject);
begin
  MaterialViewerForm.ReloadMenuItemClick(MaterialViewerForm);
  MainControlForm.LeaveModifyingMode;
end;{procedure}

function mtlGridValid(G: TStringGrid): Boolean;
var i,j: Integer;
begin
  mtlGridValid:= True;
  for i:= 1 to (G.RowCount-1) do begin
    for j:= 1 to (G.ColCount-1) do begin
      if not StrCanToPosF(G.Cells[j,i]) then mtlGridValid:= False;
    end;{for j}
  end;{for i}
end;{procedure mtlGridValid}

procedure TMaterialViewerForm.OKButtonClick(Sender: TObject);
var i: Integer;
begin
  if mtlGridValid(StringGrid_mtl) then begin
   //disable the controls which should be disabled
    MaterialViewerForm.OKButton.Enabled:= False;
    MaterialViewerForm.AddButton.Enabled:= False;
    MaterialViewerForm.DeleteButton.Enabled:= False;
    MaterialViewerForm.CancelButton.Enabled:= False;
    SetStringGrid(StringGrid_mtl,False,bsSingle,1,clGrayText);
   //update Material
    NumMaterials:= StringGrid_mtl.RowCount-1;
    SetLength(Material, StringGrid_mtl.RowCount-1);
    for i:= 1 to (StringGrid_mtl.RowCount-1) do begin
      Material[i-1].Elastic:= StrToFloat(StringGrid_mtl.Cells[1,i]);
      Material[i-1].PossionRate:= StrToFloat(StringGrid_mtl.Cells[2,i]);
      Material[i-1].UnitWeight:= StrToFloat(StringGrid_mtl.Cells[3,i]);
    end;{for}
   //regerenate structure project data
    PostLoadMakeAction;
   //enable the controls which should be enabled
    MaterialViewerForm.ReloadMenuItem.Enabled:= True;
    MaterialViewerForm.ModifyButton.Enabled:= True;
   //update GUI state variable
    MainControlForm.StructureSaved:= False;
   //enable all forms
    MainControlForm.SetAllEnabledValues(True);
   //lead to boundary viewer
    MainControlForm.LeaveModifyingMode;
    MainControlForm.ForceToModifyBoundary;
  end else begin
    MessageDlg('All materials must be real number larger than zero',
               mtInformation, [mbOK], 0);
  end;{if}
end;

procedure TMaterialViewerForm.CancelDismissButtonClick(Sender: TObject);
begin
  MaterialViewerForm.ReloadMenuItemClick(MaterialViewerForm);
  MainControlForm.LeaveModifyingMode;
  MaterialViewerVisible:= False;
  MainControlForm.MaterialViewerMenuItem.Checked:= False;
  MaterialViewerForm.Visible:= False;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;

procedure TMaterialViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  if MaterialViewerForm.ModifyButton.Enabled
  or (not MainControlForm.StructureLoaded) then begin
    MaterialViewerVisible:= False;
    MainControlForm.MaterialViewerMenuItem.Checked:= False;
    MaterialViewerForm.Visible:= False;
  end else begin
    MessageDlg('Please finish editing first', mtInformation,
               [mbOK], 0);
  end;{if}
end;

end.
