unit LinearDivisionViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, Grids, StdCtrls, ConvLib;

type
  TLinearDivisionViewerForm = class(TForm)
    LinearDivisionViewerMenu: TMainMenu;
    View1: TMenuItem;
    ReloadMenuItem: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    StringGrid_X: TStringGrid;
    StringGrid_Y: TStringGrid;
    ModifyButton: TButton;
    OkButton: TButton;
    CancelButton: TButton;
    CancelDismissButton: TButton;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure ModifyButtonClick(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CancelDismissButtonClick(Sender: TObject);
  private
    { Private declarations }
    function GridValid(G: TStringGrid):Boolean;
  public
    { Public declarations }    
  end;

var
  LinearDivisionViewerForm: TLinearDivisionViewerForm;

implementation

uses MainControl;

{$R *.DFM}

procedure TLinearDivisionViewerForm.ReloadMenuItemClick(Sender: TObject);
{Assumption: NumCol,NumRow,XDivision,YDivision are assigned
             correctly}
var i: Integer;
begin
MainControlForm.SetAllEnabledValues(False);
with LinearDivisionViewerForm do begin
 if MainControlForm.StructureLoaded then begin
    //Reload StringGrid_X
     StringGrid_X.RowCount:=NumCol+1;
     SetStringGrid(StringGrid_X, False, bsSingle, 1, clGrayText);
     StringGrid_X.Rows[0].CommaText:='Index,SubDivision,Length';
     for i:= 1 to NumCol do begin
       StringGrid_X.Cells[0,i]:=IntToStr(i);
       StringGrid_X.Cells[1,i]:=IntToStr(XDivision[i-1].NumDiv);
       StringGrid_X.Cells[2,i]:=FloatToStr(XDivision[i-1].TotalL);
     end;{for}
    //Reload StringGrid_Y
     StringGrid_Y.RowCount:=NumRow+1;
     SetStringGrid(StringGrid_Y, False, bsSingle, 1, clGrayText);
     StringGrid_Y.Rows[0].CommaText:='Index,SubDivision,Length';
     for i:= 1 to NumRow do begin
       StringGrid_Y.Cells[0,i]:=IntToStr(i);
       StringGrid_Y.Cells[1,i]:=IntToStr(YDivision[i-1].NumDiv);
       StringGrid_Y.Cells[2,i]:=FloatToStr(YDivision[i-1].TotalL);
     end;{for}
    //Reset buttons and menu item
     CancelButton.Enabled:=False;
     OKButton.Enabled:=False;
     ReloadMenuItem.Enabled:= True;
     ModifyButton.Enabled:=True;
 end else begin
     ReloadMenuItem.Enabled:= False;
     ModifyButton.Enabled:=False;
     OKButton.Enabled:=False;
     CancelButton.Enabled:= False;
     SetStringGrid(StringGrid_X, False, bsSingle, 0, clGrayText);
     SetStringGrid(StringGrid_Y, False, bsSingle, 0, clGrayText);
 end{if StructureLoaded }
end;{with}
MainControlForm.SetAllEnabledValues(True);
end;{procedure}

function TLinearDivisionViewerForm.GridValid(G: TStringGrid): Boolean;
{Post: NumCol and NumRow are assign values correctly
       G is StringGrid_X or StringGrid_Y}
var i,n: Integer;
begin
  n:=G.RowCount-1;
  GridValid:=True;
  for i:= 1 to n do begin
    if not (StrCanToPosI(G.Cells[1,i]) and StrCanToPosF(G.Cells[2,i])) then
    begin
      GridValid:=False;
    end;{if}
  end;{for}
end;{function GridValid}

procedure TLinearDivisionViewerForm.ModifyButtonClick(Sender: TObject);
begin
  if ModifyingMode then begin
    ShowMessage('Please finish the current editing');
    exit;
  end;{if ModifyingMode}
  if AnalyzingMode then begin
    ShowMessage('Structure cannot be modified in Analyzing mode');
    exit;
  end;{if AnalyzingMode}
 //set up the buttons and Grids
  with LinearDivisionViewerForm do begin
     ModifyButton.Enabled:=False;
     ReloadMenuItem.Enabled:=False;
     CancelButton.Enabled:=True;
     OKButton.Enabled:=True;
     SetStringGrid(StringGrid_X,True,bsSingle,1,clWindowText);
     SetStringGrid(StringGrid_Y,True,bsSingle,1,clWindowText);
  end;{with LinearDivisionViewerForm}
 //go to ModifyingMode
  MainControlForm.GoModifyingMode;
 //change message
  MainControlForm.MessageLabel.Caption:=
    'Message: Editing linear divisions';
end; {procedure}

procedure TLinearDivisionViewerForm.OKButtonClick(Sender: TObject);
var i: Integer;
begin
with LinearDivisionViewerForm do begin
  if GridValid(StringGrid_X) and GridValid(StringGrid_Y) then begin
   //disable controls which should be disabled
    OKButton.Enabled:=False;
    CancelButton.Enabled:=False;
    SetStringGrid(StringGrid_X,False,bsSingle,1,clGrayText);
    SetStringGrid(StringGrid_Y,False,bsSingle,1,clGrayText);
   //change XDivision and YDivision
    for i:= 1 to NumCol do begin
      XDivision[i-1].NumDiv:= StrToInt(StringGrid_X.Cells[1,i]);
      XDivision[i-1].TotalL:= StrToFloat(StringGrid_X.Cells[2,i]);
    end;{for}
    for i:= 1 to NumRow do begin
      YDivision[i-1].NumDiv:= StrToInt(StringGrid_Y.Cells[1,i]);
      YDivision[i-1].TotalL:= StrToFloat(StringGrid_Y.Cells[2,i]);
    end;{for}
   //update XLinearIndex and YLinearIndex
    SetLength(XLinearIndex, NumCol+1);
    SetLength(YLinearIndex, NumRow+1);
    XLinearIndex[0].SIndex:=1;
    XLinearIndex[0].EIndex:=1;
    XLinearIndex[0].Distance:=0;
    for i:= 1 to NumCol do begin
      XLinearIndex[i].SIndex:= XLinearIndex[i-1].SIndex
                               +2*XDivision[i-1].NumDiv;
      XLinearIndex[i].EIndex:= XLinearIndex[i-1].EIndex
                               +XDivision[i-1].NumDiv;
      XLinearIndex[i].Distance:= XLinearIndex[i-1].Distance
                                +XDivision[i-1].TotalL;
    end;{for}
    YLinearIndex[0].SIndex:=1;
    YLinearIndex[0].EIndex:=1;
    YLinearIndex[0].Distance:=0;
    for i:= 1 to NumRow do begin
      YLinearIndex[i].SIndex:= YLinearIndex[i-1].SIndex
                              +2*YDivision[i-1].NumDiv;
      YLinearIndex[i].EIndex:= YLinearIndex[i-1].EIndex
                              +YDivision[i-1].NumDiv;
      YLinearIndex[i].Distance:= YLinearIndex[i-1].Distance
                                +YDivision[i-1].TotalL;
    end;{for}
   //make the resulted change of state data
    UpdateUNodeM;
    UpdateUBlockM;
    PostLoadMakeAction;
   //refresh the influenced viewers
    MainControlForm.StructureSaved:= False;
    MainControlForm.ReloadAll(LinearDivisionViewerForm);
   //enable controls which should be enabled
    ReloadMenuItem.Enabled:=True;
    ModifyButton.Enabled:=True;
   //update the GUI state variables
    MainControlForm.StructureSaved:= False;
   //change GUI mode
    MainControlForm.LeaveModifyingMode;
   //change message
    MainControlForm.MessageLabel.Caption:=
      'Message:';
  end else begin
   //handle invalid input
    MessageDlg('Invalid Inputs',mtInformation,[mbOK],0);
  end;{if GridValid}
end;{with}
MainControlForm.LeaveModifyingMode;
end;{procedure}

procedure TLinearDivisionViewerForm.CancelButtonClick(Sender: TObject);
begin
  LinearDivisionViewerForm.Enabled:= False;
  LinearDivisionViewerForm.ReloadMenuItemClick(LinearDivisionViewerForm);
  MainControlForm.LeaveModifyingMode;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;{with}

procedure TLinearDivisionViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  if ModifyButton.Enabled
  or (not MainControlForm.StructureLoaded) then begin
    LinearDivisionViewerVisible:= False;
    MainControlForm.LinearDivisionViewerMenuItem.Checked:= False;
    LinearDivisionViewerForm.Visible:= False;
  end else begin
    MessageDlg('Please finish editing before closing the viewer',
                mtInformation, [mbOK], 0);
  end;{if}
end;

procedure TLinearDivisionViewerForm.CancelDismissButtonClick(
  Sender: TObject);
begin
  LinearDivisionViewerForm.ReloadMenuItemClick(LinearDivisionViewerForm);
  MainControlForm.LeaveModifyingMode;
  LinearDivisionViewerVisible:=False;
  MainControlForm.LinearDivisionViewerMenuItem.Checked:=False;
  LinearDivisionViewerForm.Visible:=False;
  MainControlForm.MessageLabel.Caption:=
    'Message:';
end;

end.
