unit ConvLib;

interface
uses
SysUtils, Forms, Grids, Graphics, Dialogs;

{public types}
type
TIntArray= array of Integer;

TBoundary= record
  StartNode, EndNode: Integer;
  MSequence, ESequence, SSequence: TIntArray;
end;

TUNodeM=record
  uneIndex, unsIndex: Integer;
  ShapedX, ShapedY, UnshapedX, UnshapedY: Real;
end;{record}

TUNodeS=record
  ShapedX, ShapedY,UnshapedX, UnshapedY: Real;
end;{record}

TUBlockM=record
  V1,V2,V3,V4, mtlIndex: Integer;
end;{record}

TUElementE=record
  V1,V2,V3,V4, ubmIndex: Integer;
end;{record}

TUSubElementS=record
  V1,V2,V3,V4,V5,V6, ueeIndex: Integer;
end;{record}

TLinearDivision=record
  NumDiv, SIndex, EIndex: Integer;
  TotalL, Distance: Real;
end;{record}

TLinearIndex=record
  Distance: Real;
  EIndex, SIndex: Integer;
end;{record}

TMasterOutBoundary=record
  ubnIndex: Integer;
  {
  iu, iv: Boolean;
  Shear, Pressure: Real;
  XDeformation, YDeformation: Real;
  }  //These are for update
end;{record}

TMaterial=record
  Elastic, PossionRate, UnitWeight: Real;
end;{record}

TTractionValue=record
  Pressure, Shear: Real;
end;{record}

TKinmatValue=record
  iu, iv: Integer;
  XDeformation, YDeformation: Real;
end;{record}

TBlockDiagonal=record
  ibot, jbot, itop, jtop: Integer;
end;{record}

var
  DefaultMaterialID, DefaultNumMaterials: Integer;
  DefaultElastic, DefaultPossionRate, DefaultUnitWeight: Real;
  DefaultNumDivision: Integer;
  DefaultLinearMasterDivisionLength: Real;
  UNodeM : array of TUNodeM;
  UNodeE : array of Integer;
  UNodeS : array of TUNodeS;
  DNodeM : array of Integer;
  DNodeE : array of Integer;
  DNodeS : array of Integer;
  SNUDmap: array of Integer;  //slave of DNodeS
  UBlockM : array of TUBlockM;
  BlockDiagonal: array of TBlockDiagonal; //slave of UBlockM
  UElementE : array of TUElementE;
  USubElementS : array of TUSubElementS;
  DBlockM : array of Integer;
  DElementE : array of Integer;
  DSubElementS : array of Integer;
  XDivision, YDivision : array of TLinearDivision;
  XLinearIndex, YLinearIndex : array of TLinearIndex; //slaves of *Division
  Material: array of TMaterial;
  TractionBoundary, KinmatBoundary: array of TBoundary;
  TractionValue: array of TTractionValue;
  KinmatValue: array of TKinmatValue;
  MasterOutBoundary: array of TMasterOutBoundary;
  NumCol, NumRow, NumMaterials : Integer;

{public routines}
function StrCanToInt(str: PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToInt(str:string):Boolean;Overload;external 'ConvChk.dll';
function StrCanToNonNegI(str:PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToNonNegI(str:string):Boolean;Overload;external 'ConvChk.dll';
function StrCanToPosI(str: PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToPosI(str: string):Boolean;Overload;external 'ConvChk.dll';
function StrCanToFloat(str:PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToFloat(str:string):Boolean;Overload;external 'ConvChk.dll';
function StrCanToNonNegF(str:PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToNonNegF(str:string):Boolean;Overload;external 'ConvChk.dll';
function StrCanToPosF(str:PChar):Boolean;Overload;external 'ConvChk.dll';
function StrCanToPosF(str:string):Boolean;Overload;external 'ConvChk.dll';
procedure SetStringGrid(var G: TStringGrid; alive: Boolean; bs: TBorderStyle;
          GridLineW: Integer; FontColor: TColor); external 'ConvChk.dll';
procedure Index1DTo2D(maxj,index1D: Integer; var X2D,Y2D:Integer);
procedure GetSequence(maxj,head1D,tail1D:Integer; var seq:TIntArray);
function BoundaryValid(var B: array of TBoundary): Integer;
procedure SetDefaultParameters(MaterialID: Integer;
                       Elastic, PossionRate, UnitWeight: Real;
                       NumDivision: Integer; LinearMasterDivisionLength: Real);
                       export;
procedure SaveProject(PathName: string);
procedure LoadProject(PathName: string);
procedure PostLoadMakeAction;
function ProjectExist (PathName: string): Integer;
procedure LoadProjectHead(PathName: string);
procedure SaveProjectHead(PathName: string);
procedure MakeDefaultLinearDivision;
procedure LoadLinearDivision(PathName: string);
procedure SaveLinearDivision(pathname: string);
procedure MakeDefaultUNodeM;
procedure UpdateUNodeM;
procedure LoadUNodeM(PathName: string);
procedure SaveUNodeM(PathName: string);
procedure MakeUNodeE;
procedure MakeUNodeS;
procedure MakeDNodeM;
procedure MakeDNodeE;
procedure MakeDNodeS;
procedure MakeDefaultUBlockM;
procedure UpdateUBlockM;
procedure LoadUBlockM(PathName: string);
procedure SaveUBlockM(PathName: string);
procedure MakeUElementE;
procedure MakeUSubElementS;
procedure MakeDBlockM;
procedure MakeDElementE;
procedure MakeDSubElementS;
procedure MakeDefaultMaterial;
procedure LoadMaterial(PathName: string);
procedure SaveMaterial(PathName: string);
procedure MakeDefaultTraction;
procedure LoadTraction(PathName: string);
procedure SaveTraction(PathName: string);
procedure MakeDefaultKinmat;
procedure LoadKinmat(PathName: string);
procedure SaveKinmat(PathName: string);
procedure MakeMasterOutBoundary;


function GetUBlockVertexCoord(UBlockMid,VertexSelect:Integer; XYSelect:Char;
                              Shaped:Boolean): Real;
procedure GetUBlockVertexCoordV(UBlockMid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
procedure GetUElementVertexCoordV(UElementEid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
procedure GetUSubElementVertexCoordV(USubElementEid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
procedure GetDBlockVertexCoordV(DBlockMid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
procedure GetDElementVertexCoordV(DElementEid: Integer; Shaped: Boolean;
                                 var Xbuf, Ybuf: array of Real);
procedure GetDSubElementVertexCoordV(DSubElementSid: Integer;
                                     Shaped: Boolean;
                                     var Xbuf, Ybuf: array of Real);
function GetSubElementMaterial(SubElementIndex: Integer): Integer;
procedure GetPolygonConerTypeV(NumConer: integer; X, Y: array of real;
                          var ConerType: array of real);
function uIndexSame(maxj, Index1, Index2: Integer): Boolean;
function vIndexSame(maxj, Index1, Index2: Integer): Boolean;

                                    
implementation
{Definition for private Data Structures}
  //reserved

{Definition for private functions}
function Index2DTo1D(maxj, i, j: Integer): Integer;
{Note: Indexing is started from 1}
begin
  Index2DTo1D:=(i-1)*maxj+j;
end;{function Index2DTo1D}

procedure Index1DTo2D(maxj,index1D: Integer; var X2D,Y2D:Integer);
{assumption: all indexes are start from 1}
begin
  if (index1D)mod(maxj)=0 then X2D:=(index1D)div(maxj)
  else X2D:= ((index1D)div(maxj))+1;
  if (index1D)mod(maxj)=0 then Y2D:= maxj
  else Y2D:=(index1D)mod(maxj);
end;{function Index1DTo2DX}

function Index1DNodeTo1DPiece(maxjNode: Integer; X,Y: string;
                   NodeIndex1D: Integer): Integer;
{assumption: 1)maxjNode is the maximum j index of nodes in the
               possible area
               X is either 'left' or 'right', not case-sensitive
               Y is either 'bottom' or 'top', not case-sensitive
               NodeIndex1D is the 1D Index of input node
               all indexing start from 1
             2)if NodeIndex1D is on the edge of possible area, the
               combination of X and Y should be restrict. for
               example, if the node is on the lower left coner of
               possible area, X and Y can only be 'left' and 'bottom'
 post:   X='left' and Y='bottom'
       =>the input node is the left-lower coner of the output piece}
var
  c,r, i,j: Integer;  //c, r are 2D index of the piece
                      //i, j are 2D index of the Node
begin
  Index1DTo2D(maxjNode, NodeIndex1D, i, j);
  if lowercase(X)='left' then begin
    c:= i;
  end else if lowercase(X)='right' then begin
    c:= i-1;
  end else begin
   {impossible}
    c:=0;
  end;{if}
  if lowercase(Y)='bottom' then begin
    r:= j;
  end else if lowercase(Y)='top' then begin
    r:= j-1;
  end else begin
   {impossible}
    r:=0;
  end;{if}
  Index1DNodeTo1DPiece:= (c-1)*(maxjNode-1)+r;
end;{function IndexDNodeTo1DPiece}

function uIndexSame(maxj, Index1, Index2: Integer): Boolean;
{assumption: Index1 Index2 are 1D index, doesn't matter for
             nodes or pieces
             maxj is the maximum possible j value of 2D index
 post:       indicate if Index1 and Index2 are in the same row  }
var
  i1, j1, i2, j2: Integer;
begin
  Index1DTo2D(maxj,Index1,i1,j1);
  Index1DTo2D(maxj,Index2,i2,j2);
  if i1=i2 then uIndexSame:= True
  else uIndexSame:= False;
end;{function uIndexSame}

function vIndexSame(maxj, Index1, Index2: Integer): Boolean;
{assumption: Index1 Index2 are 1D index, doesn't matter for
             nodes or pieces
             maxj is the maximum possible j value of 2D index
 assumption: indicate if Index1 and Index2 are in the same column }
var
  i1, j1, i2, j2: Integer;
begin
  Index1DTo2D(maxj,Index1,i1,j1);
  Index1DTo2D(maxj,Index2,i2,j2);
  if j1=j2 then vIndexSame:= True
  else vIndexSame:= False;
end;{function uIndexSame}

function Index1DOnEdge (maxi, maxj, Index1D: Integer): Integer;
{assumption: 1)maxi,maxj is the maximum 2D indexes of either
               blocks or nodes. Index1D is the 1D index of either
               a block or a node. three inputs are either all for
               blocks or all for nodes
             2)Index1D <= maxi*maxj
             3)all indexes start from 1
 post: 0<=Index1DOnBound<=5
      -1: overflow, node is out of the possible area
       0: node is inside the possible area
       1: left edge of possible area
          (not including coners)
       2: left-bottom coner of possible area
       3: bottom edge of possible area
          (not including coners)
       4: bottom-right coner of possible area
       5: right edge of possible area
          (not including coners)
       6: right-top coner of possible area
       7: top edge of possible area
          (not including coners
       8: top-right coner of possible area
       9: logically impossible, reserved for debug }
var i,j: Integer;
begin
  if Index1D>(maxi*maxj) then begin
   //overflow execption
    Index1DOnEdge:=-1;
  end else begin
   //get the 2D indexes
    Index1DTo2D(maxj, Index1D, i, j);
   //check other cases
         if (1<i)and(i<maxi)and(1<j)and(j<maxj) then Index1DOnEdge:=0
    else if (i=1)and(1<j)and(j<maxj) then Index1DOnEdge:=1
    else if (i=1)and(j=1) then Index1DOnEdge:=2
    else if (1<i)and(i<maxi)and(j=1) then Index1DOnEdge:=3
    else if (i=maxi)and(j=1) then Index1DOnEdge:=4
    else if (i=maxi)and(1<j)and(j<maxj) then Index1DOnEdge:=5
    else if (i=maxi)and(j=maxj) then Index1DOnEdge:=6
    else if (1<i)and(i<maxi)and(j=maxj) then Index1DOnEdge:=7
    else if (i=1)and(j=maxj) then Index1DOnEdge:=8
    else begin
      //impossible
       Index1DOnEdge:=9;
    end; {if}
  end; {if}
end;{Index1DOnEdge}

function UNodeMOnStructure(UNodeMIndex:Integer): Integer;
{assumption: 1)NumCol, NumRow, UBlockM, NumMaterials are assigned
             2) 1<=UNodeMIndex<=(NumCol+1)*(NumRow+1)
 post: -2=> unpredicted mistake
        0=> it is not on the surface of structure
        1=> it is on the surface of structure
        2=> it is inside the structure
 expected change: to regonize 3 cases: inside/outside/OnSurface   }
var
  LeftBottom, RightBottom, RightTop, LeftTop: Integer; //block indexes
  LeftBottomAvail, RightBottomAvail,     //Indicates if the blocks
  RightTopAvail, LeftTopAvail: Boolean;  //are available
  NodePosition: Integer;
begin
 //obtain the 1D indexs of possible blocks, which given node can
 //be one of its vertices
 //some so the resulted index may not be valid, but
 //the execption will be eliminated later
  LeftBottom := Index1DNodeTo1DPiece
                (NumRow+1, 'left', 'bottom', UNodeMIndex);
  RightBottom:= Index1DNodeTo1DPiece
                (NumRow+1, 'right','bottom', UNodeMIndex);
  RightTop   := Index1DNodeTo1DPiece
                (NumRow+1, 'right','top',    UNodeMIndex);
  LeftTop    := Index1DNodeTo1DPiece
                (NumRow+1, 'left', 'top',    UNodeMIndex);
 //to find next master boundary node by checking blocks
  NodePosition:= Index1DOnEdge(NumCol+1, NumRow+1, UNodeMIndex);
  if NodePosition=0 then begin
   {this is the most popular case}
   //find out the which block around the input node is available
      LeftBottomAvail :=(UBlockM[LeftBottom].mtlIndex in [1..NumMaterials]);
      RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
      RightTopAvail   :=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
      LeftTopAvail    :=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
      if (LeftBottomAvail or RightBottomAvail
         or LeftTopAvail or RightTopAvail) then
      begin
        UNodeMOnStructure:= 2;
        if not(LeftBottomAvail and RightBottomAvail
          and LeftTopAvail and RightTopAvail) then
        begin
          UNodeMOnStructure:= 1;
        end;{if}
      end else begin
        UNodeMOnStructure:= 0;
      end;{if}
  end else if NodePosition=1 then begin
    //left edge of possible area
    LeftTopAvail:=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
    LeftBottomAvail :=(UBlockM[LeftBottom].mtlIndex in [1..NumMaterials]);
    if (LeftTopAvail or LeftBottomAvail) then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=2 then begin
    //lower left coner of possible area
    LeftTopAvail:=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
    if LeftTopAvail then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=3 then begin
    //lower edge of possible area
    LeftBottomAvail :=(UBlockM[LeftBottom].mtlIndex in [1..NumMaterials]);
    RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
    if (LeftBottomAvail or RightBottomAvail) then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=4 then begin
    //lower right coner of possible area
    RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
    if RightBottomAvail then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=5 then begin
    //right edge of possible area
    RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
    RightTopAvail   :=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
    if (RightBottomAvail or RightTopAvail) then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=6 then begin
    //upper right coner of possible area
    RightTopAvail:=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
    if RightTopAvail then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=7 then begin
    //upper edge of possible area
    RightTopAvail:=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
    LeftTopAvail :=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
    if (RightTopAvail or LeftTopAvail) then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else if NodePosition=8 then begin
    //upper left coner of possible area
    LeftTopAvail :=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
    if LeftTopAvail then UNodeMOnStructure:= 1
    else UNodeMOnStructure:= 0;
  end else begin
   //impossible
    UNodeMOnStructure:= -2;
  end;{if}
end;{function MIndexToX}

function MEdgeOnStructure(mn1, mn2: Integer): Integer;
{assumption: 1)Node1D1 and Node1D2 are valid Master Undiscarded
               Node Indices start from 1; they are at the same
               row or same column
             2)NumCol, NumRow, UBlockM, NumMaterials are assigned
               correctly
 post: 0=>linear segment is not in structure
       1=>linear segment is on the surface of structure
       2=>linear segment is inside the structure
      -1=>exception  }
var
  pos1,pos2: Integer;
  ans: Integer;
begin
 //intialize the result
  ans:= 0;
 //get the position of mn1 and mn2 in possible area
  pos1:= Index1DOnEdge(NumCol+1, NumRow+1, mn1);
  pos2:= Index1DOnEdge(NumCol+1, NumRow+1, mn2);
 //use conditioning to judge the cases
  if (pos1=0) or (pos2=0) then begin
    if uIndexSame(NumRow+1, mn1, mn2) then begin
      if (mn1>mn2) then begin
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn1)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn1)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
      end else if (mn1<mn2) then begin
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn2)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn2)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
      end;  {if mn1 >/< mn2}
    end else if vIndexSame(NumRow+1, mn1, mn2) then begin
      if (mn1>mn2) then begin
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn2)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn2)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
      end else if (mn1<mn2) then begin
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn1)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
        if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn1)-1].mtlIndex
            in [1..NumMaterials]) then ans:=ans+1;
      end; {if pos1 >/< pos2}
    end; {if [u/v]IndexSame}
  end else if (pos1=2) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn1)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos2=2) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn2)-1].mtlIndex
        in [1..NumMaterials])
        then ans:=ans+1;
  end else if (pos1=4) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','bottom',mn1)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos2=4) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','bottom',mn2)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos1=6) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn1)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos2=6) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn2)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos1=8) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn1)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos2=8) then begin
    if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn2)-1].mtlIndex
        in [1..NumMaterials]) then ans:=ans+1;
  end else if (pos1=1) and (pos2=1) then begin
    if (mn1>mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn1)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end else if (mn1<mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn2)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end;
  end else if (pos1=3) and (pos2=3) then begin
    if (mn1>mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn2)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end else if (mn1<mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','bottom',mn1)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end;
  end else if (pos1=5) and (pos2=5) then begin
    if (mn1>mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn1)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end else if (mn1<mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'right','top',mn2)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end;
  end else if (pos1=7) and (pos2=7) then begin
    if (mn1>mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn2)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end else if (mn1<mn2) then begin
      if (UBlockM[Index1DNodeTo1DPiece(NumRow+1,'left','top',mn1)-1].mtlIndex
          in [1..NumMaterials]) then ans:=ans+1;
    end;
  end else begin
    //exception
     ans:= -1;
  end;{if position cases}
  MEdgeOnStructure:= ans;
end;{procedure MEdgeOnStructure}

function BoundaryValid(var B: array of TBoundary): Integer;
{assumption: NumRow, UBlockM, NumMaterials are assigned correctly
 post: 1) only test B[i].MSequence, and 0<=i<=length(B)
       2) out put code:
          0=> not a valid boundary
          1=> a surface boundary
          2=> a boundary which is not all on surface, part of
              the segments are inside
         -1=> Exception
       3  the pass by reference of parameter is only for the purpose
          of not coursing error; the parameter is not suppose
          to be modified }
var
  i, j, l1, l2: Integer;
  EdgeStat: Integer;
  ans: Integer;
begin
  ans:=1;
  l1:= length(B);
  if l1>0 then begin
  for i:= 1 to l1 do begin
    l2:= length(B[i-1].MSequence);
    if l2>=2 then begin
    for j:= 1 to (l2-1) do begin
      EdgeStat:= MEdgeOnStructure( B[i-1].MSequence[j-1],
                                   B[i-1].MSequence[j] );
      if EdgeStat=2 then begin
        ans:= 2;
      end else if EdgeStat=0 then begin
        ans:= 0;
        BoundaryValid:= ans;
        Exit;
      end else if EdgeStat<>1 then begin
        ans:= -1;
        BoundaryValid:= ans;
        Exit;
      end;{if EdgeStat}
    end;{for j:= 1 to l2}
    end else begin
      ans:=-1;
      BoundaryValid:= ans;
      Exit;
    end;
  end;{for i:= 1 to l1}
  end;{if}
  BoundaryValid:= ans;
end; {procedure BoundaryValid}

procedure GetSequence(maxj, head1D, tail1D: Integer;
                      var seq: TIntArray);
{assumption: 1) head1D and tail1D form a valid boundary segment
                of structure
             2) maxj is the maximum j index starts from1,
                head1D and tail1D are 1D index start from 1
 post:  seq is a dynamic array which contains the nodes between
        head1D, and tail1D, including head1D and tail1D
 note:  this routine can be applied to block indexing  }
var l,i: integer;
begin
  if uIndexSame(maxj, head1D, tail1D) then begin
    //in the same column
    l:= abs(head1D-tail1D)+1;
    SetLength(seq, l);
    seq[0]:= head1D;
    if head1D>tail1D then begin
     //decreasing
      for i:= 1 to (l-1) do seq[i]:= seq[i-1]-1;
    end else if head1D<tail1D then begin
     //increasing
      for i:= 1 to (l-1) do seq[i]:= seq[i-1]+1;
    end else begin
      //exception
          //do nothing
    end;
  end else if vIndexSame(maxj, head1D, tail1D) then begin
    //in the same row;
    l:= (abs(head1D-tail1D)div(maxj))+1;
    SetLength(seq, l);
    seq[0]:= head1D;
    if head1D>tail1D then begin
      //decreasing
        for i:= 1 to (l-1) do
          seq[i]:= seq[i-1]-maxj;
    end else if head1D<tail1D then begin
      //increasing
        for i:= 1 to (l-1) do
          seq[i]:= seq[i-1]+maxj;
    end else begin
      //exception
          //do nothing
    end;
  end else begin
    //exception: neither in the same column nor row
    l:= 0;
    SetLength(seq, l);
  end;
end;


//  This function is more than sufficiant because it's
//functionality is by-passed by TLinearDivision structure
function MIndexToY(MIndex: Integer):Real;
{assumption: YDivision is correctly assigned and
             1<=MIndex<=Length(YDivision)}
var i: Integer; ans: Real;
begin
  ans:=0;
  for i:=1 to (MIndex-1) do ans:=ans+YDivision[i-1].TotalL;
  MindexToY:=ans;
end;{function MIndexToX}

function Shape(s,t, X1, X2, X3, X4: Real): Real;
begin
  Shape:=X1*(1-s)*(1-t)+X2*(1-t)*s+X3*s*t+X4*(1-s)*t;
end; {function Shape}


function GetUBlockVertexCoord(UBlockMid,VertexSelect:Integer; XYSelect:Char;
                              Shaped:Boolean): Real;  overload
{assumption: 1) 1<=VertexSelect<=4, 1 means lower left conner, 1 to 4
                counts in counter-Clockwise order
             2) XYSelect is in ('X' 'x' 'Y' 'y')   }
var Node: TUNodeM;
begin
  case VertexSelect of
  1: Node:=UNodeM[UBlockM[UBlockMid-1].V1-1];
  2: Node:=UNodeM[UBlockM[UBlockMid-1].V2-1];
  3: Node:=UNodeM[UBlockM[UBlockMid-1].V3-1];
  4: Node:=UNodeM[UBlockM[UBlockMid-1].V4-1];
  else{Impossible}end;{case}
  if ((XYSelect='X') or (XYSelect='x')) and Shaped then begin
    Result:=Node.ShapedX;
  end else if ((XYSelect='X') or (XYSelect='x'))  and (not Shaped) then begin
    Result:=Node.UnShapedX;
  end else if ((XYSelect='Y') or (XYSelect='y'))  and Shaped then begin
    Result:=Node.ShapedY;
  end else if ((XYSelect='Y') or (XYSelect='y'))  and (not Shaped) then begin
    Result:=Node.UnShapedY;
  end else begin
   {Impossible}
    Result:=-1;
  end;{if}
end;{function GetUBlockVertexCoord}

procedure GetUBlockVertexCoordV(UBlockMid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
{assumption: 1)UBlockMid starts with 1
             2)Size of Xbuf and Ybuf are 4 }
begin
  if Shaped then begin
    Xbuf[0]:= UNodeM[UBlockM[UBlockMid-1].V1-1].ShapedX;
    Ybuf[0]:= UNodeM[UBlockM[UBlockMid-1].V1-1].ShapedY;
    Xbuf[1]:= UNodeM[UBlockM[UBlockMid-1].V2-1].ShapedX;
    Ybuf[1]:= UNodeM[UBlockM[UBlockMid-1].V2-1].ShapedY;
    Xbuf[2]:= UNodeM[UBlockM[UBlockMid-1].V3-1].ShapedX;
    Ybuf[2]:= UNodeM[UBlockM[UBlockMid-1].V3-1].ShapedY;
    Xbuf[3]:= UNodeM[UBlockM[UBlockMid-1].V4-1].ShapedX;
    Ybuf[3]:= UNodeM[UBlockM[UBlockMid-1].V4-1].ShapedY;
  end else begin
    Xbuf[0]:= UNodeM[UBlockM[UBlockMid-1].V1-1].UnshapedX;
    Ybuf[0]:= UNodeM[UBlockM[UBlockMid-1].V1-1].UnshapedY;
    Xbuf[1]:= UNodeM[UBlockM[UBlockMid-1].V2-1].UnshapedX;
    Ybuf[1]:= UNodeM[UBlockM[UBlockMid-1].V2-1].UnshapedY;
    Xbuf[2]:= UNodeM[UBlockM[UBlockMid-1].V3-1].UnshapedX;
    Ybuf[2]:= UNodeM[UBlockM[UBlockMid-1].V3-1].UnshapedY;
    Xbuf[3]:= UNodeM[UBlockM[UBlockMid-1].V4-1].UnshapedX;
    Ybuf[3]:= UNodeM[UBlockM[UBlockMid-1].V4-1].UnshapedY;
  end;
end;{procedure GetUBlockVertexCoordV}

procedure GetUElementVertexCoordV(UElementEid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
{assumption: 1)UElementEid starts with 1
             2)Size of Xbuf and Ybuf are 4 }
begin
  if Shaped then begin
    Xbuf[0]:= UNodeS[UNodeE[UElementE[UElementEid-1].V1-1]-1].ShapedX;
    Ybuf[0]:= UNodeS[UNodeE[UElementE[UElementEid-1].V1-1]-1].ShapedY;
    Xbuf[1]:= UNodeS[UNodeE[UElementE[UElementEid-1].V2-1]-1].ShapedX;
    Ybuf[1]:= UNodeS[UNodeE[UElementE[UElementEid-1].V2-1]-1].ShapedY;
    Xbuf[2]:= UNodeS[UNodeE[UElementE[UElementEid-1].V3-1]-1].ShapedX;
    Ybuf[2]:= UNodeS[UNodeE[UElementE[UElementEid-1].V3-1]-1].ShapedY;
    Xbuf[3]:= UNodeS[UNodeE[UElementE[UElementEid-1].V4-1]-1].ShapedX;
    Ybuf[3]:= UNodeS[UNodeE[UElementE[UElementEid-1].V4-1]-1].ShapedY;
  end else begin
    Xbuf[0]:= UNodeS[UNodeE[UElementE[UElementEid-1].V1-1]-1].UnshapedX;
    Ybuf[0]:= UNodeS[UNodeE[UElementE[UElementEid-1].V1-1]-1].UnshapedY;
    Xbuf[1]:= UNodeS[UNodeE[UElementE[UElementEid-1].V2-1]-1].UnshapedX;
    Ybuf[1]:= UNodeS[UNodeE[UElementE[UElementEid-1].V2-1]-1].UnshapedY;
    Xbuf[2]:= UNodeS[UNodeE[UElementE[UElementEid-1].V3-1]-1].UnshapedX;
    Ybuf[2]:= UNodeS[UNodeE[UElementE[UElementEid-1].V3-1]-1].UnshapedY;
    Xbuf[3]:= UNodeS[UNodeE[UElementE[UElementEid-1].V4-1]-1].UnshapedX;
    Ybuf[3]:= UNodeS[UNodeE[UElementE[UElementEid-1].V4-1]-1].UnshapedY;
  end;
end;{procedure GetUElementVertexCoord}

procedure GetUSubElementVertexCoordV(USubElementEid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
{assumption: 1)USubElementEid starts with 1
             2)Size of Xbuf and Ybuf are 6 }
begin
  if Shaped then begin
    Xbuf[0]:=UNodeS[USubElementS[USubElementEid-1].V1-1].ShapedX;
    Ybuf[0]:=UNodeS[USubElementS[USubElementEid-1].V1-1].ShapedY;
    Xbuf[1]:=UNodeS[USubElementS[USubElementEid-1].V2-1].ShapedX;
    Ybuf[1]:=UNodeS[USubElementS[USubElementEid-1].V2-1].ShapedY;
    Xbuf[2]:=UNodeS[USubElementS[USubElementEid-1].V3-1].ShapedX;
    Ybuf[2]:=UNodeS[USubElementS[USubElementEid-1].V3-1].ShapedY;
    Xbuf[3]:=UNodeS[USubElementS[USubElementEid-1].V4-1].ShapedX;
    Ybuf[3]:=UNodeS[USubElementS[USubElementEid-1].V4-1].ShapedY;
    Xbuf[4]:=UNodeS[USubElementS[USubElementEid-1].V5-1].ShapedX;
    Ybuf[4]:=UNodeS[USubElementS[USubElementEid-1].V5-1].ShapedY;
    Xbuf[5]:=UNodeS[USubElementS[USubElementEid-1].V6-1].ShapedX;
    Ybuf[5]:=UNodeS[USubElementS[USubElementEid-1].V6-1].ShapedY;
  end else begin
    Xbuf[0]:=UNodeS[USubElementS[USubElementEid-1].V1-1].UnshapedX;
    Ybuf[0]:=UNodeS[USubElementS[USubElementEid-1].V1-1].UnshapedY;
    Xbuf[1]:=UNodeS[USubElementS[USubElementEid-1].V2-1].UnshapedX;
    Ybuf[1]:=UNodeS[USubElementS[USubElementEid-1].V2-1].UnshapedY;
    Xbuf[2]:=UNodeS[USubElementS[USubElementEid-1].V3-1].UnshapedX;
    Ybuf[2]:=UNodeS[USubElementS[USubElementEid-1].V3-1].UnshapedY;
    Xbuf[3]:=UNodeS[USubElementS[USubElementEid-1].V4-1].UnshapedX;
    Ybuf[3]:=UNodeS[USubElementS[USubElementEid-1].V4-1].UnshapedY;
    Xbuf[4]:=UNodeS[USubElementS[USubElementEid-1].V5-1].UnshapedX;
    Ybuf[4]:=UNodeS[USubElementS[USubElementEid-1].V5-1].UnshapedY;
    Xbuf[5]:=UNodeS[USubElementS[USubElementEid-1].V6-1].UnshapedX;
    Ybuf[5]:=UNodeS[USubElementS[USubElementEid-1].V6-1].UnshapedY;
  end;
end;{procedure GetUSubElementVertexCoordV}

procedure GetDBlockVertexCoordV(DBlockMid: Integer; Shaped: Boolean;
                               var Xbuf, Ybuf: array of Real);
{assumption: 1)DBlockMid starts with 1
             2)Size of Xbuf and Ybuf are 4 }
begin
  if Shaped then begin
    Xbuf[0]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V1-1].ShapedX;
    Ybuf[0]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V1-1].ShapedY;
    Xbuf[1]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V2-1].ShapedX;
    Ybuf[1]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V2-1].ShapedY;
    Xbuf[2]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V3-1].ShapedX;
    Ybuf[2]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V3-1].ShapedY;
    Xbuf[3]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V4-1].ShapedX;
    Ybuf[3]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V4-1].ShapedY;
  end else begin
    Xbuf[0]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V1-1].UnshapedX;
    Ybuf[0]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V1-1].UnshapedY;
    Xbuf[1]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V2-1].UnshapedX;
    Ybuf[1]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V2-1].UnshapedY;
    Xbuf[2]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V3-1].UnshapedX;
    Ybuf[2]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V3-1].UnshapedY;
    Xbuf[3]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V4-1].UnshapedX;
    Ybuf[3]:= UNodeM[UBlockM[DBlockM[DBlockMid-1]-1].V4-1].UnshapedY;
  end;
end;{procedure GetDBlockVertexCoordV}

procedure GetDElementVertexCoordV(DElementEid: Integer; Shaped: Boolean;
                                 var Xbuf, Ybuf: array of Real);
{assumption: 1)DElementEid starts with 1
             2)Size of Xbuf and Ybuf are 4 }
begin
if Shaped then begin
Xbuf[0]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V1-1]-1].ShapedX;
Ybuf[0]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V1-1]-1].ShapedY;
Xbuf[1]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V2-1]-1].ShapedX;
Ybuf[1]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V2-1]-1].ShapedY;
Xbuf[2]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V3-1]-1].ShapedX;
Ybuf[2]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V3-1]-1].ShapedY;
Xbuf[3]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V4-1]-1].ShapedX;
Ybuf[3]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V4-1]-1].ShapedY;
end else begin
Xbuf[0]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V1-1]-1].UnshapedX;
Ybuf[0]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V1-1]-1].UnshapedY;
Xbuf[1]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V2-1]-1].UnshapedX;
Ybuf[1]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V2-1]-1].UnshapedY;
Xbuf[2]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V3-1]-1].UnshapedX;
Ybuf[2]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V3-1]-1].UnshapedY;
Xbuf[3]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V4-1]-1].UnshapedX;
Ybuf[3]:= UNodeS[UNodeE[UElementE[DElementE[DElementEid-1]-1].V4-1]-1].UnshapedY;
end;
end;{procedure GetDElementVertexCoordV}

procedure GetDSubElementVertexCoordV(DSubElementSid: Integer;
                                     Shaped: Boolean;
                                     var Xbuf, Ybuf: array of Real);
{assumption: 1)DSubElementSid starts with 1
             2)Size of Xbuf and Ybuf are 6 }
begin
if Shaped then begin
Xbuf[0]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V1-1].ShapedX;
Ybuf[0]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V1-1].ShapedY;
Xbuf[1]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V2-1].ShapedX;
Ybuf[1]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V2-1].ShapedY;
Xbuf[2]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V3-1].ShapedX;
Ybuf[2]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V3-1].ShapedY;
Xbuf[3]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V4-1].ShapedX;
Ybuf[3]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V4-1].ShapedY;
Xbuf[4]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V5-1].ShapedX;
Ybuf[4]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V5-1].ShapedY;
Xbuf[5]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V6-1].ShapedX;
Ybuf[5]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V6-1].ShapedY;
end else begin
Xbuf[0]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V1-1].UnshapedX;
Ybuf[0]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V1-1].UnshapedY;
Xbuf[1]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V2-1].UnshapedX;
Ybuf[1]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V2-1].UnshapedY;
Xbuf[2]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V3-1].UnshapedX;
Ybuf[2]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V3-1].UnshapedY;
Xbuf[3]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V4-1].UnshapedX;
Ybuf[3]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V4-1].UnshapedY;
Xbuf[4]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V5-1].UnshapedX;
Ybuf[4]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V5-1].UnshapedY;
Xbuf[5]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V6-1].UnshapedX;
Ybuf[5]:= UNodeS[USubElementS[DSubElementS[DSubElementSid-1]-1].V6-1].UnshapedY;
end;
end;{procedure GetDSubElementVertexCoordV}

function GetElementMaterial(ElementIndex: Integer): Integer;
begin
  GetElementMaterial:=
      UBlockM[ UElementE[ElementIndex-1].ubmIndex-1].mtlIndex;
end; {function GetElementMaterial}

function GetSubElementMaterial(SubElementIndex: Integer): Integer;
begin
  GetSubElementMaterial:=
    UBlockM[
           UElementE [
                     USubElementS[SubElementIndex-1].ueeIndex-1
           ].ubmIndex-1
           ].mtlIndex;
end; {function GetSubElementMaterial}

procedure GetPolygonConerTypeV(NumConer: integer; X, Y: array of real;
                          var ConerType: array of real);
{assumption: 1) (X[0],Y[0]), (X[1],Y[1])...(X[NumConer-1],Y[NumConer-1])
                are the coordinates of vertices of an enclosed polygon,
                in conter-clock-wise order
             2) NumConer = number of coners of polygon
                         = number of edges of polygon
             3) length(X) >= NumConer
                length(Y) >= NumConer
                length(ConerType) >= NumConer + 1
             4) for all integer i, so that 1<=i<=NumConer
                (X[i-1],Y[i-1]) represents the ith coner of polygon
 post: 1) for all integer i, so that 1<=i<=NumConer:
            (the ith coner is concave) ==> ConerType[i]=2
            (the ith coner is 180 degree) ==> ConerType[i]=1
            (the ith coner is convex) ==> ConerType[i]=0
       2) ConerType[0] = number of coners which is 180 degree or concave
 notes: first coner starts from index 1 instead of 0 in ConerType,
        keep in mind }
var
  i: integer;
  CrossProduct: real;
  xV1, yV1, xV2, yV2: real;
begin
  ConerType[0]:= 0;
 //test the first coner
  xV1:= X[0]-X[NumConer-1];
  yV1:= Y[0]-Y[NumConer-1];
  xV2:= X[1]-X[0];
  yV2:= Y[1]-Y[0];
  CrossProduct:= xV1*yV2 - yV1*xV2;
  if CrossProduct>0 then begin
    ConerType[1]:= 0;
  end else if CrossProduct<0 then begin
    ConerType[1]:= 2;
    ConerType[0]:= ConerType[0]+1;
  end else begin
   //180 degree
    ConerType[1]:= 1;
    ConerType[0]:= ConerType[0]+1;
  end;{if CrossProduct}
 //test the other coners
  for i:= 2 to NumConer do begin
    xV1:= X[i-1]-X[i-2];
    yV1:= Y[i-1]-Y[i-2];
    xV2:= X[i]-X[i-1];
    yV2:= Y[i]-Y[i-1];
    CrossProduct:= xV1*yV2 - yV1*xV2;
    if CrossProduct>0 then begin
      ConerType[i]:= 0;
    end else if CrossProduct<0 then begin
      ConerType[i]:= 2;
      ConerType[0]:= ConerType[0]+1;
    end else begin
     //180 degree
      ConerType[i]:= 1;
      ConerType[0]:= ConerType[0]+1;
    end;{if CrossProduct}
  end;{for 2 to NumConer}
end;{procedure GetPolygonConerTypeV}

function GetMasterOutBoundaryNode: Integer;
{assumption:1) UBlockM, NumMaterials are assigned
            2) at least on possible block is avaliable
 post: return 1D index of a node on boundary of avaliable
       blocks start from 1}
var b,nb: Integer;
begin
  nb:=length(UBlockM);
  b:=1;
  while not( (UBlockM[b].mtlIndex in [1..NumMaterials])
            or (b>nb)  ) do
  begin
    b:=b+1;
  end;{while}
  if b>nb then begin
   //This is an exception that no block is available
    GetMasterOutBoundaryNode:= -1;
  end else begin
   //To get the 1D index of lower-left node of b-th block
    GetMasterOutBoundaryNode:= UBlockM[b].V1;
  end;{if}
end; {function GetMasterOutBoundaryNode}

function GetNextMasterOutBoundaryNode(BoundaryNodeIndex: Integer): Integer;
{assumption: 1) NumCol, NumRow, UBlockM, NumMaterials are assigned
             2) The input BoundaryNodeIndex is a node on the boundary
                of avaliable blocks
             3) all blocks are connected to a whole chunk   
 post: the segment between input and output is part of the boundary
       line of avaliable blocks.
       out is on the counter-clockwise direction of input }
var
  leftN, rightN, upN, downN: Integer; //node indexes
  LeftBottom, RightBottom, RightTop, LeftTop: Integer; //block indexes
  LeftBottomAvail, RightBottomAvail,     //  Indicates if the blocks
  RightTopAvail, LeftTopAvail: Boolean;  //are available
  i,j, NodePosition: Integer;
begin
  Index1DTo2D(NumRow+1, BoundaryNodeIndex, i, j);
 //obtain the 1D indexes of nodes next to the given node,
 //some so the resulted index may not be valid, but
 //the execption will be eliminated later
  leftN:= Index2DTo1D(NumRow+1, i-1, j);
  rightN:= Index2DTo1D(NumRow+1,i+1, j);
  downN:= Index2DTo1D(NumRow+1, i, j-1);
  upN:= Index2DTo1D(NumRow+1, i, j+1);
 //obtain the 1D indexs of possible blocks, which given node can
 //be one of its vertices
 //some so the resulted index may not be valid, but
 //the execption will be eliminated later
  LeftBottom := Index1DNodeTo1DPiece
                (NumRow+1, 'left', 'bottom', BoundaryNodeIndex);
  RightBottom:= Index1DNodeTo1DPiece
                (NumRow+1, 'right','bottom', BoundaryNodeIndex);
  RightTop   := Index1DNodeTo1DPiece
                (NumRow+1, 'right','top',    BoundaryNodeIndex);
  LeftTop    := Index1DNodeTo1DPiece
                (NumRow+1, 'left', 'top',    BoundaryNodeIndex);
 //to find next master boundary node by checking blocks
  NodePosition:= Index1DOnEdge(NumCol+1, NumRow+1, BoundaryNodeIndex);
  if NodePosition=0 then begin
   {this is the most popular case}
   //find out the which block around the input node is available
      LeftBottomAvail :=(UBlockM[LeftBottom].mtlIndex in [1..NumMaterials]);
      RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
      RightTopAvail   :=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
      LeftTopAvail    :=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
      if LeftBottomAvail and (not LeftTopAvail) then
          GetNextMasterOutBoundaryNode:= rightN
      else if RightBottomAvail and (not LeftBottomAvail) then
          GetNextMasterOutBoundaryNode:= upN
      else if RightTopAvail and (not RightBottomAvail) then
          GetNextMasterOutBoundaryNode:= leftN
      else if LeftTopAvail and (not RightTopAvail) then
          GetNextMasterOutBoundaryNode:= downN
      else begin
        //impossible
          GetNextMasterOutBoundaryNode:= -1;
      end;{if}
  end else if NodePosition=1 then begin
    LeftTopAvail:=(UBlockM[LeftTop].mtlIndex in [1..NumMaterials]);
    if LeftTopAvail then GetNextMasterOutBoundaryNode:= downN
    else GetNextMasterOutBoundaryNode:= rightN;
  end else if NodePosition=2 then begin
    GetNextMasterOutBoundaryNode:= rightN;
  end else if NodePosition=3 then begin
    LeftBottomAvail :=(UBlockM[LeftBottom].mtlIndex in [1..NumMaterials]);
    if LeftBottomAvail then GetNextMasterOutBoundaryNode:= rightN
    else GetNextMasterOutBoundaryNode:= upN;
  end else if NodePosition=4 then begin
    GetNextMasterOutBoundaryNode:= upN;
  end else if NodePosition=5 then begin
    RightBottomAvail:=(UBlockM[RightBottom].mtlIndex in [1..NumMaterials]);
    if RightBottomAvail then GetNextMasterOutBoundaryNode:= upN
    else GetNextMasterOutBoundaryNode:= leftN;
  end else if NodePosition=6 then begin
    GetNextMasterOutBoundaryNode:= leftN;
  end else if NodePosition=7 then begin
    RightTopAvail:=(UBlockM[RightTop].mtlIndex in [1..NumMaterials]);
    if RightTopAvail then GetNextMasterOutBoundaryNode:= leftN
    else GetNextMasterOutBoundaryNode:= downN;
  end else if NodePosition=8 then begin
    GetNextMasterOutBoundaryNode:= downN;
  end else begin
   //impossible
    GetNextMasterOutBoundaryNode:= -2;
  end;
end; {function GetNextMasterOutBoundaryNode}

{Definition for exported functions}
function ProjectExist (PathName: string): Integer;
begin
  ProjectExist:=3;
  if not FileExists(PathName+'.ubm') then ProjectExist:=2;
  if not FileExists(PathName+'.unm') then ProjectExist:=2;
  if not FileExists(PathName+'.mtl') then ProjectExist:=2;
  if not FileExists(PathName+'.trc') then ProjectExist:=2;
  if not FileExists(PathName+'.kin') then ProjectExist:=2;
  if not FileExists(PathName+'.div') then ProjectExist:=1;
  if not FileExists(PathName+'.poj') then ProjectExist:=0;
end;{function ProjectExist}

procedure SaveProject(PathName: string);
{ assumption: all state variables are loaded }
begin
  SaveProjectHead(PathName);
  SaveMaterial(PathName);
  SaveTraction(PathName);
  SaveKinmat(PathName);
  SaveLinearDivision(PathName);
  SaveUNodeM(PathName);
  SaveUBlockM(PathName);
end;{procedure SaveProject}

procedure LoadProject(PathName: string);
{assumption: the project files exist in the path
             indicated by PathName}
begin
  if ProjectExist(PathName)=3 then begin
   //all project files are ready
    LoadMaterial(PathName);
    LoadProjectHead(PathName);
    LoadLinearDivision(PathName);
    LoadUNodeM(PathName);
    LoadUBlockM(PathName);
    PostLoadMakeAction;
    LoadTraction(PathName);
    LoadKinmat(PathName);
  end else if ProjectExist(PathName)=2 then begin
   //the project is only initialized, but haven't been viewed or edited
    MakeDefaultMaterial;
    LoadProjectHead(PathName);
    LoadLinearDivision(PathName);
    MakeDefaultUNodeM;
    MakeDefaultUBlockM;
    PostLoadMakeAction;
    MakeDefaultTraction;
    MakeDefaultKinmat;
  end else if ProjectExist(PathName)=1 then begin
   //lack of LinearDivision file
    LoadProjectHead(PathName);
    MakeDefaultLinearDivision;
    MakeDefaultMaterial;
    MakeDefaultUNodeM;
    MakeDefaultUBlockM;
    PostLoadMakeAction;
    MakeDefaultTraction;
    MakeDefaultKinmat;
  end else if ProjectExist(PathName)=0 then begin
   //don't have project head file, project cannot be opened
    MessageDlg('Project not exist', mtInformation, [mbOK], 0);
  end else begin
   //logically impossible, reserve for debug
   MessageDlg('Unknown error to open project', mtInformation, [mbOK], 0);
  end;{if ProjectExist}
end;{procedure LoadProject}

procedure PostLoadMakeAction;
{ assumption: all data need to be loaded or made default
              is ready
}
begin
  MakeDBlockM;
  MakeDNodeM;
  MakeUElementE;
  MakeDElementE;
  MakeUNodeE;
  MakeDNodeE;
  MakeUSubElementS;
  MakeDSubElementS;
  MakeUNodeS;
  MakeDNodeS;
end;{procedure PostLoadMakeAction;}

procedure LoadProjectHead(PathName: string);
{assumptions:
      1) PathName is path and filename without extension
      2) Project Exists }
var F: TextFile;
begin
  AssignFile(F, PathName+'.poj');
  Reset(F);
  Read(F, NumCol, NumRow);
  CloseFile(F);
end;{procedure LoadProjectHead}

procedure SaveProjectHead(PathName: string);
{assumption: NumCol and NumRow are assigned}
var F: TextFile;
begin
  AssignFile(F, PathName+'.poj');
  rewrite(F);
  writeln(F, NumCol, ' ', NumRow);
  CloseFile(F);
end;{procedure SaveProjectHead}

procedure MakeDefaultLinearDivision;
{ assumption: NumCol and NumRow are already correctly assigned
  post: XDivision, YDivision, XLinearIndex, YLinearIndex
        are assigned }
var i: Integer;
begin
  SetLength(XDivision, NumCol);
  SetLength(XLinearIndex, NumCol+1);
  SetLength(YDivision, NumRow);
  SetLength(YLinearIndex, NumRow+1);
  {Assign XDivision and YDivision}
  for i:= 0 to (NumCol-1) do begin
    XDivision[i].NumDiv:=DefaultNumDivision;
    XDivision[i].TotalL:=DefaultLinearMasterDivisionLength;
  end;{for}
  for i:= 0 to (NumRow-1) do begin
    XDivision[i].NumDiv:=DefaultNumDivision;
    XDivision[i].TotalL:=DefaultLinearMasterDivisionLength;
  end;{for}
 {Assign XLinearIndex and YLinearIndex }
  XLinearIndex[0].SIndex:=1;
  XLinearIndex[0].EIndex:=1;
  XLinearIndex[0].Distance:=0;
  for i:= 1 to NumCol do begin
    XLinearIndex[i].SIndex:= XLinearIndex[i-1].SIndex
                            +2*XDivision[i-1].NumDiv;
    XLinearIndex[i].EIndex:= XLinearIndex[i-1].EIndex
                            +XDivision[i-1].NumDiv;
    XLinearIndex[i].Distance:= XLinearIndex[i-1].Distance
                              +XDivision[i-1].TotalL;
  end;{for}
  YLinearIndex[0].SIndex:=1;
  YLinearIndex[0].EIndex:=1;
  YLinearIndex[0].Distance:=0;
  for i:= 1 to NumRow do begin
    YLinearIndex[i].SIndex:= YLinearIndex[i-1].SIndex
                            +2*YDivision[i-1].NumDiv;
    YLinearIndex[i].EIndex:= YLinearIndex[i-1].EIndex
                            +YDivision[i-1].NumDiv;
    YLinearIndex[i].Distance:= YLinearIndex[i-1].Distance
                              +YDivision[i-1].TotalL;
  end;{for}
end;{procedure MakeDefaultLinearDoivision}

procedure LoadLinearDivision(PathName: string); //Checked
{assumptions:
  1) PathName is path and filename without extension
  2) NumCol and NumRow are assigned correctly
  3) File Exists
 post: XDivision YDivision XLinearIndex YLinearIndex assigned }
var F: TextFile; i: Integer;
begin
 {Assign XDivision and YDivision fields}
  AssignFile(F, PathName+'.div');
  reset(F);
 //XDivision
  SetLength(XDivision, NumCol);
  for i:= 0 to (NumCol-1) do begin
    read(F, XDivision[i].NumDiv, XDivision[i].TotalL);
  end;{for}
 //YDivision
  SetLength(YDivision, NumRow);
  for i:= 0 to (NumRow-1) do begin
    read(F, YDivision[i].NumDiv, YDivision[i].TotalL);
  end;{for}
  CloseFile(F);
 {Assign XLinearIndex and YLinearIndex }
  SetLength(XLinearIndex, NumCol+1);
  SetLength(YLinearIndex, NumRow+1);
  XLinearIndex[0].SIndex:=1;
  XLinearIndex[0].EIndex:=1;
  XLinearIndex[0].Distance:=0;
  for i:= 1 to NumCol do begin
    XLinearIndex[i].SIndex:= XLinearIndex[i-1].SIndex
                            +2*XDivision[i-1].NumDiv;
    XLinearIndex[i].EIndex:= XLinearIndex[i-1].EIndex
                            +XDivision[i-1].NumDiv;
    XLinearIndex[i].Distance:= XLinearIndex[i-1].Distance
                              +XDivision[i-1].TotalL;
  end;{for}
  YLinearIndex[0].SIndex:=1;
  YLinearIndex[0].EIndex:=1;
  YLinearIndex[0].Distance:=0;
  for i:= 1 to NumRow do begin
    YLinearIndex[i].SIndex:= YLinearIndex[i-1].SIndex
                            +2*YDivision[i-1].NumDiv;
    YLinearIndex[i].EIndex:= YLinearIndex[i-1].EIndex
                            +YDivision[i-1].NumDiv;
    YLinearIndex[i].Distance:= YLinearIndex[i-1].Distance
                              +YDivision[i-1].TotalL;
  end;{for}
end;{procedure LoadLinearDivision}

procedure SaveLinearDivision(pathname: string);
{assumptions:
  1) PathName is path and filename without extension
  2) NumCol and NumRow are assigned correctly}
var F:TextFile; i: Integer;
begin
  AssignFile(F, pathname+'.div');
  Rewrite(F);
  for i:= 0 to (NumCol-1) do begin
    write(F, XDivision[i].NumDiv, ' ', XDivision[i].TotalL, ' ');
  end;{for}
  writeln(F);
  for i:= 0 to (NumRow-1) do begin
    write(F, YDivision[i].NumDiv, ' ', YDivision[i].TotalL, ' ');
  end;{for}
  CloseFile(F);
end;{procedure SaveLineardivision}

procedure MakeDefaultUNodeM;
{ assumption: NumCol, NumRow, XDivision, YDivision, XLinearIndex,
              YLinearIndex are correctly assigned
  post: All fields of the array items are assigned ("uneIndex"
        "unsIndex" "ShapedX", "ShapedY", "UnShapedX", "UnShapedY"). }
var
  i,j,k,Emaxv,Smaxv: Integer;
begin
  SetLength(UNodeM,(NumCol+1)*(NumRow+1));
  Emaxv:=YLinearIndex[NumRow].EIndex;
  Smaxv:=YLinearIndex[NumRow].SIndex;
 {assign the coordinates and "uneIndex" "unsIndex" fields of nodes}
  for i:=1 to (NumCol+1) do begin
    for j:=1 to (NumRow+1) do begin
     //k is the index of Node
      k:=Index2DTo1D(NumRow+1,i,j);
     //assign the coordinates
      UNodeM[k-1].UnshapedX:=XLinearIndex[i-1].Distance;
      UNodeM[k-1].ShapedX:=UNodeM[k-1].UnshapedX;
      UNodeM[k-1].UnshapedY:=YLinearIndex[j-1].Distance;
      UNodeM[k-1].ShapedY:=UNodeM[k-1].UnshapedY;
     //assign "uneIndex" field
      UNodeM[k-1].uneIndex:=Index2DTo1D(Emaxv, XLinearIndex[i-1].EIndex,
                                        YLinearIndex[j-1].EIndex);
     //assign "unsIndex" field
      UNodeM[k-1].unsIndex:=Index2DTo1D(Smaxv, XLinearIndex[i-1].SIndex,
                                        YLinearIndex[j-1].SIndex);
    end;{for}
  end;{for}
end;{procedure MakeDefaultUNodeM}

procedure UpdateUNodeM;
{assumption: 1) NumCol, NumRow, XDivision, YDivision, XLinearIndex,
                YLinearIndex are correctly assigned
             2) XDivision, YDivision, XLinearIndex, YLinearIndex
                are updated, they only change in values of each elements,
                but not the lengths
 post: 1) following are not changed: the length of UNodeM, the
          "UnshapedX" "UnshapedY" fields
       2) following are possible to change: "ShapedX" "ShapedY"
          "uneIndex" "unsIndex" fields   }
var
  i,j,k,Emaxv,Smaxv: Integer;
begin
  Emaxv:=YLinearIndex[NumRow].EIndex;
  Smaxv:=YLinearIndex[NumRow].SIndex;
 {update "UnshapedX" "UnshapedY" "uneIndex" "unsIndex" fields of nodes}
  for i:=1 to (NumCol+1) do begin
    for j:=1 to (NumRow+1) do begin
     //k is the index of Node
      k:=Index2DTo1D(NumRow+1,i,j);
     //assign the unshaped coordinates
      UNodeM[k-1].UnshapedX:=XLinearIndex[i-1].Distance;
      UNodeM[k-1].UnshapedY:=YLinearIndex[j-1].Distance;
     //assign "uneIndex" field
      UNodeM[k-1].uneIndex:=Index2DTo1D(Emaxv, XLinearIndex[i-1].EIndex,
                                        YLinearIndex[j-1].EIndex);
     //assign "unsIndex" field
      UNodeM[k-1].unsIndex:=Index2DTo1D(Smaxv, XLinearIndex[i-1].SIndex,
                                        YLinearIndex[j-1].SIndex);
    end;{for}
  end;{for}
end; {procedure UpdateUNodeM}

procedure LoadUNodeM(PathName: string);
{ assumption: file "PathName+'.unm'" exists }
var
  F: TextFile;
  i,l: Integer;
begin
 {set the size of UNodeM by checking the file}
  AssignFile(F, PathName+'.unm');
  reset(F);
  l:= 0;
  while not SeekEof(F) do begin
    readln(F);
    l:=l+1;
  end;{while}
  SetLength(UNodeM, l);
 {assign values to UNodeM}
  reset(F);
  for i:= 1 to l do begin
    readln(F, UNodeM[i-1].uneIndex, UNodeM[i-1].unsIndex,
              UNodeM[i-1].ShapedX,  UNodeM[i-1].ShapedY,
              UNodeM[i-1].UnshapedX,UNodeM[i-1].UnshapedY);
  end;{for}
  CloseFile(F);
end;{procedure LoadUNodeM}

procedure SaveUNodeM(PathName: string);
{ assumption: 1) PathName indicates an existing folder
              2) UNodeM is assigned correctly }
var
  F: TextFile;
  i,l: Integer;
begin
  l:= length(UNodeM);
  AssignFile(F, PathName+'.unm');
  rewrite(F);
  for i:= 1 to l do begin
    writeln(F, UNodeM[i-1].uneIndex, ' ',UNodeM[i-1].unsIndex,
           ' ',UNodeM[i-1].ShapedX,  ' ',UNodeM[i-1].ShapedY,
           ' ',UNodeM[i-1].UnshapedX,' ',UNodeM[i-1].UnshapedY);
  end;{for}
  CloseFile(F);
end;{procedure SaveUNodeM}

procedure MakeUNodeE;
{assumption: NumCol, NumRow, XDivision and
             YDivision are fully assigned }
var
  Emaxu,Emaxv, Smaxv,Su,Sv, i,j,k: Integer;
begin
  Smaxv:=YLinearIndex[NumRow].SIndex;
  Emaxu:=XLinearIndex[NumCol].EIndex;
  Emaxv:=YLinearIndex[NumRow].EIndex;
  SetLength(UNodeE,Emaxu*Emaxv);
  for i:= 1 to Emaxu do begin
    for j:= 1 to Emaxv do begin
     //A fact: 2*(Eindex-1)=Sindex-1(found by counting on
     //the graph), implies Sindex=2*Eindex-1
      Su:= 2*i-1;
      Sv:= 2*j-1;
      k := Index2DTo1D(Emaxv, i, j);
      UNodeE[k-1]:= Index2DTo1D(Smaxv, Su, Sv);
      end;{for}
  end;{for}
end;{procedure MakeUNodeE}

procedure MakeUNodeS;
{assumptions: NumCol, NumRow, XDivision, YDivision
              and UNodeM are assigned }
var
  b,i,j,u,v,k, nb,Smaxu,Smaxv: Integer;
  s,t, di,dj: Real;
   X1, X2, X3, X4, Y1, Y2, Y3, Y4: Real; //Shaped coordinates
  uX1,uX2,uX3,uX4,uY1,uY2,uY3,uY4: Real; //Unshaped coordinates
begin
 {Initialize the size of UNodeS}
  //the number of SubElement 1D Index on X direction
  Smaxu:=XLinearIndex[NumCol].SIndex;
  //the number of SubElement 1D Index on Y direction
  Smaxv:=YLinearIndex[NumRow].SIndex;
  nb:=Length(UBlockM);
  SetLength(UNodeS, Smaxu*Smaxv);
 {Assign values to InitUNodeS}
  //Works for each blocks individually 
  for b:=1 to nb do begin
    di:=1/(BlockDiagonal[b-1].itop-BlockDiagonal[b-1].ibot);
    dj:=1/(BlockDiagonal[b-1].jtop-BlockDiagonal[b-1].jbot);
    X1:= GetUBlockVertexCoord(b,1,'X',True);
    X2:= GetUBlockVertexCoord(b,2,'X',True);
    X3:= GetUBlockVertexCoord(b,3,'X',True);
    X4:= GetUBlockVertexCoord(b,4,'X',True);
    Y1:= GetUBlockVertexCoord(b,1,'Y',True);
    Y2:= GetUBlockVertexCoord(b,2,'Y',True);
    Y3:= GetUBlockVertexCoord(b,3,'Y',True);
    Y4:= GetUBlockVertexCoord(b,4,'Y',True);
    uX1:= GetUBlockVertexCoord(b,1,'X',False);
    uX2:= GetUBlockVertexCoord(b,2,'X',False);
    uX3:= GetUBlockVertexCoord(b,3,'X',False);
    uX4:= GetUBlockVertexCoord(b,4,'X',False);
    uY1:= GetUBlockVertexCoord(b,1,'Y',False);
    uY2:= GetUBlockVertexCoord(b,2,'Y',False);
    uY3:= GetUBlockVertexCoord(b,3,'Y',False);
    uY4:= GetUBlockVertexCoord(b,4,'Y',False);
    for i:=BlockDiagonal[b-1].ibot to BlockDiagonal[b-1].itop do begin
      s:=(i-BlockDiagonal[b-1].ibot)*di;
      for j:= BlockDiagonal[b-1].jbot to BlockDiagonal[b-1].jtop do begin
        t:=(j-BlockDiagonal[b-1].jbot)*dj;
        k:=Index2DTo1D(Smaxv, i, j);
        UNodeS[k-1].ShapedX:=Shape(s,t,X1,X2,X3,X4);
        UNodeS[k-1].ShapedY:=Shape(s,t,Y1,Y2,Y3,Y4);
        UNodeS[k-1].UnshapedX:=Shape(s,t,uX1,uX2,uX3,uX4);
        UNodeS[k-1].UnshapedY:=Shape(s,t,uY1,uY2,uY3,uY4);
      end;{for}
    end;{for}
  end;{for}
end;{procedure MakeUNodeS}

procedure MakeDNodeM;
{assumption: DBlockM, UBlockM, UNodeM are assigned}
var
  indexDNodeM, i, b, nb, sizeDNodeM: Integer;
  UNMbuffer: array of Integer;
begin
  nb:= length(DBlockM);
  SetLength(UNMbuffer, length(UNodeM));
 //initialize UNMbuffer to -1 which is an impossible index
  for i:= 1 to length(UNMbuffer) do UNMbuffer[i-1]:= -1;
 //assign UNMbuffer, 0 means node avaliable
  for b:= 1 to nb do begin
    UNMbuffer[UBlockM[DBlockM[b-1]-1].V1-1]:= 0;
    UNMbuffer[UBlockM[DBlockM[b-1]-1].V2-1]:= 0;
    UNMbuffer[UBlockM[DBlockM[b-1]-1].V3-1]:= 0;
    UNMbuffer[UBlockM[DBlockm[b-1]-1].V4-1]:= 0;
  end; {for}
 //get the size of DNodeM
  sizeDNodeM := 0;
  for i:= 1 to length(UNMbuffer) do begin
    if UNMbuffer[i-1]=0 then sizeDNodeM := sizeDNodeM+1;
  end;{for}
  SetLength(DNodeM, sizeDNodeM);
 //assign DNodeM
  indexDNodeM:=0;
  for i:= 1 to length(UNMbuffer) do begin
    if UNMbuffer[i-1]=0 then begin
      indexDNodeM:= indexDNodeM+1;
      DNodeM[indexDNodeM-1]:= i;
    end;{if}
  end;{for}
end; {procedure MakeDNodeM}

procedure MakeDNodeE;
{assumption: DElementE, UElementE, UNodeE are assigned}
var
  indexDNodeE, i, e, ne, sizeDNodeE: Integer;
  UNEbuffer: array of Integer;
begin
  ne:= length(DElementE);
  SetLength(UNEbuffer, length(UNodeE));
 //initialize UNEbuffer to -1 which is an impossible index
  for i:= 1 to length(UNEbuffer) do UNEbuffer[i-1]:= -1;
 //assign UNEbuffer, 0 means node avaliable
  for e:= 1 to ne do begin
    UNEbuffer[UElementE[DElementE[e-1]-1].V1-1]:= 0;
    UNEbuffer[UElementE[DElementE[e-1]-1].V2-1]:= 0;
    UNEbuffer[UElementE[DElementE[e-1]-1].V3-1]:= 0;
    UNEbuffer[UElementE[DElementE[e-1]-1].V4-1]:= 0;
  end; {for}
 //get the size of DNodeE
  sizeDNodeE := 0;
  for i:= 1 to length(UNEbuffer) do begin
    if UNEbuffer[i-1]=0 then sizeDNodeE := sizeDNodeE+1;
  end;{for}
  SetLength(DNodeE, sizeDNodeE);
 //assign DNodeE
  indexDNodeE:=0;
  for i:= 1 to length(UNEbuffer) do begin
    if UNEbuffer[i-1]=0 then begin
      indexDNodeE:= indexDNodeE+1;
      DNodeE[indexDNodeE-1]:= i;
    end;{if}
  end;{for}
end; {procedure MakeDNodeE}

procedure MakeDNodeS;
{assumption: DSubElementS, USubElementS, UNodeS are assigned}
var
  indexDNodeS, i, s, ns, sizeDNodeS: Integer;
  UNSbuffer: array of Integer;
begin
  ns:= length(DSubElementS);
  SetLength(UNSbuffer, length(UNodeS));
 //initialize UNSbuffer to -1 which is an impossible index
  for i:= 1 to length(UNSbuffer) do UNSbuffer[i-1]:= -1;
 //assign UNSbuffer, 0 means node avaliable
  for s:= 1 to ns do begin
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V1-1]:= 0;
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V2-1]:= 0;
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V3-1]:= 0;
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V4-1]:= 0;
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V5-1]:= 0;
    UNSbuffer[USubElementS[DSubElementS[s-1]-1].V6-1]:= 0;
  end; {for}
 //get the size of DNodeS
  sizeDNodeS:= 0;
  for i:= 1 to length(UNSbuffer) do begin
    if UNSbuffer[i-1]=0 then sizeDNodeS := sizeDNodeS+1;
  end;{for}
  SetLength(DNodeS, sizeDNodeS);
 //assign DNodeS
  indexDNodeS:=0;
  for i:= 1 to length(UNSbuffer) do begin
    if UNSbuffer[i-1]=0 then begin
      indexDNodeS:= indexDNodeS+1;
      DNodeS[indexDNodeS-1]:= i;
    end;{if}
  end;{for}
 //assign SNUDmap
  SetLength(SNUDmap, length(UNSbuffer));
  indexDNodeS:=0;
  for i:= 1 to length(UNSbuffer) do begin
    if UNSbuffer[i-1]=0 then begin
      indexDNodeS:= indexDNodeS+1;
      SNUDmap[i-1]:= indexDNodeS;
    end else begin
      SNUDmap[i-1]:= -1;
    end;{if}
  end;{for}
end; {procedure MakeDNodeS}

procedure MakeDefaultUBlockM;
{assumption:1) NumCol, NumRow, XDivision, and YDivision are assigned
            2) DefaultMaterialID is assigned
 post:  1) UBlockM is assigned
        2) BlockDiagonal is assigned }
var i,j,k: Integer;
begin
 {Assign UBlockM}
  SetLength(UBlockM, NumCol*NumRow);
  for i:= 1 to NumCol do begin
    for j:= 1 to NumRow do begin
      k:=Index2DTo1D(NumRow,i,j);   //k is the index of block
      UBlockM[k-1].V1:=Index2DTo1D(NumRow+1,i,j);
      UBlockM[k-1].V2:=Index2DTo1D(NumRow+1,i+1,j);
      UBlockM[k-1].V3:=Index2DTo1D(NumRow+1,i+1,j+1);
      UBlockM[k-1].V4:=Index2DTo1D(NumRow+1,i,j+1);
      UBlockM[k-1].mtlIndex:=DefaultMaterialID;
    end;{for}
  end;{for}
 {Assign BlockDiagonal}
  SetLength(BlockDiagonal, NumCol*NumRow);
  for i:= 1 to NumCol do begin
    for j:= 1 to NumRow do begin
      k:=Index2DTo1D(NumRow, i, j);  //k is the index of block
      BlockDiagonal[k-1].ibot:=XLinearIndex[i-1].SIndex;
      BlockDiagonal[k-1].itop:=XLinearIndex[i].SIndex;
      BlockDiagonal[k-1].jbot:=YLinearIndex[j-1].SIndex;
      BlockDiagonal[k-1].jtop:=YLinearIndex[j].SIndex;
    end;{for}
  end;{for}
end; {procedure MakeDefaultUBlockM}

procedure UpdateUBlockM;
{assumption: 1) following are possible to be changed:
                XDivision, YDivision, XLinearIndex, YLinearIndex
                but their length are not updated
             2) UBlockM already existed
 post: 1)following are not changed:
         the lengths of UBlockM and BlockDiagonal
         all fields of UBlockM
       2)following are possible to be changed:
         all fields of BlockDiagonal  }
var i, j, k: Integer;
begin
  for i:= 1 to NumCol do begin
    for j:= 1 to NumRow do begin
      k:=Index2DTo1D(NumRow, i, j);  //k is the index of block
      BlockDiagonal[k-1].ibot:=XLinearIndex[i-1].SIndex;
      BlockDiagonal[k-1].itop:=XLinearIndex[i].SIndex;
      BlockDiagonal[k-1].jbot:=YLinearIndex[j-1].SIndex;
      BlockDiagonal[k-1].jtop:=YLinearIndex[j].SIndex;
    end;{for}
  end;{for}
end;

procedure LoadUBlockM(PathName: string);
{assumption: 1) "PathName+'.ubm'" is an existing file
             2) NumCol, NumRow, XDivision, YDivision are assigned
 post:  1) UBlockM is assigned
        2) BlockDiagonal is assigned }
var
  F: TextFile;
  i,j,k,l: Integer;
begin
  AssignFile(F, PathName+'.ubm');
  reset(F);
 {set the size of UBlockM by reading though the file}
  l:= 0;
  while not SeekEof(F) do begin
    readln(F);
    l:= l+1;
  end;{while}
 {assign the UBlockM}
  reset(F);
  SetLength(UBlockM, l);
  for i:= 1 to l do begin
    readln(F, UBlockM[i-1].V1, UBlockM[i-1].V2, UBlockM[i-1].V3,
              UBlockM[i-1].V4, UBlockM[i-1].mtlIndex);
  end;{for}
  CloseFile(F);
 {Assign BlockDiagonal}
  SetLength(BlockDiagonal, NumCol*NumRow);
  for i:= 1 to NumCol do begin
    for j:= 1 to NumRow do begin
      k:=Index2DTo1D(NumRow, i, j);  //k is the index of block
      BlockDiagonal[k-1].ibot:=XLinearIndex[i-1].SIndex;
      BlockDiagonal[k-1].itop:=XLinearIndex[i].SIndex;
      BlockDiagonal[k-1].jbot:=YLinearIndex[j-1].SIndex;
      BlockDiagonal[k-1].jtop:=YLinearIndex[j].SIndex;
    end;{for}
  end;{for}
end; {procedure LoadUBlockM}

procedure SaveUBlockM(PathName: string);
{assumption: 1) UBlockM is assigned
             2) PathName contains existing path}
var
  F: TextFile;
  i,l: Integer;
begin
  l:= Length(UBlockM);
  AssignFile(F, PathName+'.ubm');
  rewrite(F);
  for i:= 1 to l do begin
    writeln(F, UBlockM[i-1].V1,' ',UBlockM[i-1].V2,' ',UBlockM[i-1].V3,
           ' ',UBlockM[i-1].V4,' ',UBlockM[i-1].mtlIndex);
  end;{for}
  CloseFile(F);
end;{procedure SaveUBlockM}

procedure MakeUElementE;
{assumption: NumCol, NumRow, XDivision, YDivision, UNodeM are assigned}
var
  Emaxu, Emaxv, nb, b,i,j,k, left, bottom,right,top : Integer;
begin
  nb:= NumCol*NumRow;
  Emaxu:= XLinearIndex[NumCol].EIndex;
  Emaxv:= YLinearIndex[NumRow].EIndex;
  SetLength( UElementE, (Emaxu-1)*(Emaxv-1) );
  for b:= 1 to nb do begin
    Index1DTo2D(Emaxv, UNodeM[UBlockM[b-1].V1-1].uneIndex, left, bottom);
    Index1DTo2D(Emaxv, UNodeM[UBlockM[b-1].V3-1].uneIndex, right, top);
    for i:= left to (right-1) do begin
      for j:= bottom to (top-1) do begin
       //find index of Element piece with index transformation
        k:= Index2DTo1D(Emaxv-1, i, j);
       //the following index transformation is to find the node index
        UElementE[k-1].V1:= Index2DTo1D(Emaxv, i,   j  );
        UElementE[k-1].V2:= Index2DTo1D(Emaxv, i+1, j  );
        UElementE[k-1].V3:= Index2DTo1D(Emaxv, i+1, j+1);
        UElementE[k-1].V4:= Index2DTo1D(Emaxv, i,   j+1);
       //assign the "ubmIndex" field
        UElementE[k-1].ubmIndex:= b;           
      end;{for j}
    end;{for i}
  end{for b}
end;{procedure MakeUElementE}

procedure MakeUSubElementS;
{assumption: NumCol, NumRow, XDivision, YDivision, UElementE,
             are assigned}
var
  Smaxv,Emaxu,Emaxv,Eu,Ev,Su,Sv,i,ne : Integer;
begin
  Smaxv:=YLinearIndex[NumRow].SIndex;
  Emaxu:=XLinearIndex[NumCol].EIndex;
  Emaxv:=YLinearIndex[NumRow].EIndex;
  ne:= (Emaxu-1)*(Emaxv-1);  //number of elements
  SetLength(USubElementS, 2*ne);
  for i:= 1 to ne do begin
   //Eu, Ev are the element level of X, Y node indexes start from 1
    Index1DTo2D(Emaxv, UElementE[i-1].V1 , Eu, Ev);
   //fact1: 2*(Eindex-1)=Sindex-1 implies Sindex=2*Eindex-1 for linear
   //  UElementE[i].V1, USubElementS[2*i-1].V1, USubElementS[2*i].V1
   //  are the same node.
   //Su, Sv are the sub-element level of X, Y node indexes start from 1
    Su:= 2*Eu-1;
    Sv:= 2*Ev-1;
   //assign values for the first sub-element
    USubElementS[(2*i-1)-1].V1:= Index2DTo1D(Smaxv, Su,   Sv);
    USubElementS[(2*i-1)-1].V2:= Index2DTo1D(Smaxv, Su+1, Sv);
    USubElementS[(2*i-1)-1].V3:= Index2DTo1D(Smaxv, Su+2, Sv);
    USubElementS[(2*i-1)-1].V4:= Index2DTo1D(Smaxv, Su+2, Sv+1);
    USubElementS[(2*i-1)-1].V5:= Index2DTo1D(Smaxv, Su+2, Sv+2);
    USubElementS[(2*i-1)-1].V6:= Index2DTo1D(Smaxv, Su+1, Sv+1);
    USubElementS[(2*i-1)-1].ueeIndex:= i;
   //assign values for the second sub-element
    USubElementS[2*i-1].V1:= Index2DTo1D(Smaxv, Su,   Sv);
    USubElementS[2*i-1].V2:= Index2DTo1D(Smaxv, Su+1, Sv+1);
    USubElementS[2*i-1].V3:= Index2DTo1D(Smaxv, Su+2, Sv+2);
    USubElementS[2*i-1].V4:= Index2DTo1D(Smaxv, Su+1, Sv+2);
    USubElementS[2*i-1].V5:= Index2DTo1D(Smaxv, Su,   Sv+2);
    USubElementS[2*i-1].V6:= Index2DTo1D(Smaxv, Su,   Sv+1);
    USubElementS[2*i-1].ueeIndex:= i;
  end;{for}
end;{procedure MakeUSubElementS}

procedure MakeDBlockM;
{assumption: UBlockM and NumMaterial is assigned correctly }
var i,ld,lu,k: Integer;
begin
 {find the number of avaliable blocks: size of DBlockM}
 //note: size of DBlockM needs be set before
 //      assigning DBlockM
  lu:=Length(UBlockM);
  ld:=0;
  for i:= 1 to lu do begin
    if UBlockM[i-1].mtlIndex in [1..NumMaterials] then ld:=ld+1;
  end;{for}
 {assign DBlockM}
  SetLength(DBlockM,ld);
  k:=1;
  for i:= 1 to lu do begin
    if UBlockM[i-1].mtlIndex in [1..NumMaterials] then begin
      DBlockM[k-1]:=i;
      k:=k+1;
    end;{if}
  end;{for}
end;{procedure MakeDBlockM}

procedure MakeDElementE;
{assumption: UElementE and NumMaterial is assigned correctly}
var i,ld,lu,k: Integer;
begin
  lu:=Length(UElementE);
  ld:=0;
  for i:= 1 to lu do begin
    if GetElementMaterial(i) in [1..NumMaterials] then ld:=ld+1;
  end;{for}
 {assign DElementE}
  SetLength(DElementE,ld);
  k:=1;
  for i:= 1 to lu do begin
    if GetElementMaterial(i) in [1..NumMaterials] then begin
      DElementE[k-1]:=i;
      k:=k+1;
    end;{if}
  end;{for}
end;{procedure MakeDElementE}

procedure MakeDSubElementS;
{assumption: UElementE and NumMaterial is assigned correctly}
var i,ld,lu,k: Integer;
begin
  lu:=Length(USubElementS);
  ld:=0;
  for i:= 1 to lu do begin
    if GetSubElementMaterial(i) in [1..NumMaterials] then ld:=ld+1;
  end;{for}
 {assign DSubElementS}
  SetLength(DSubElementS,ld);
  k:=1;
  for i:= 1 to lu do begin
    if GetSubElementMaterial(i) in [1..NumMaterials] then begin
      DSubElementS[k-1]:=i;
      k:=k+1;
    end;{if}
  end;{for}
end;{procedure MakeSubElementS}

procedure SetDefaultParameters(MaterialID: Integer;
                       Elastic, PossionRate, UnitWeight: Real;
                       NumDivision: Integer; LinearMasterDivisionLength: Real);
begin
  DefaultMaterialID:=MaterialID;
  DefaultElastic:=Elastic;
  DefaultPossionRate:=PossionRate;
  DefaultUnitWeight:=UnitWeight;
  DefaultNumDivision:=NumDivision;
  DefaultLinearMasterDivisionLength:=LinearMasterDivisionLength;
end; {procedure SetDefaultParameters}

procedure MakeDefaultMaterial;
{assumption: The state variables "DefaultElastic" "DefaultPossionRate"
             and "DefaultUnitWeight" are assigned
 post:  Assign 1 to "NumMaterials"}
begin
  NumMaterials:=1;
  SetLength(Material, 1);
  Material[0].Elastic:=DefaultElastic;
  Material[0].PossionRate:=DefaultPossionRate;
  Material[0].UnitWeight:=DefaultUnitWeight;
end;{procedure MakeDefaultMaterial}

procedure LoadMaterial(PathName: string);
{assumption: 1)PathName is full path and file name without extension
             2)file "PathName+'.mtl'" exists and it is not empty
 post:  fully assign "Material" and the
        state variable "NumMaterials" }
var
  F: TextFile;
  i: Integer;
  E,P,W: Real;
begin
  AssignFile(F, PathName+'.mtl');
 {Fine how many lines there are in the file}
  reset(F);
  NumMaterials:=0;
  while not SeekEof(F) do begin
    readln(F);
    NumMaterials:=NumMaterials+1;
  end;{while}
 {Read the content of the file in}
  SetLength(Material,NumMaterials);
  reset(F);
  for i:= 1 to NumMaterials do begin
    readln(F, E, P, W);
    Material[i-1].Elastic:=E;
    Material[i-1].PossionRate:=P;
    Material[i-1].UnitWeight:=W;
  end;{for}
  CloseFile(F);
end;{procedure LoadMaterial}

procedure SaveMaterial(PathName: string);
{assumption: PathName contains a valid path}
var
  F: TextFile;
  i,l: Integer;
begin
  l:=Length(Material);
  AssignFile(F, PathName+'.mtl');
  rewrite(F);
  for i:= 1 to l do begin
    writeln(F, Material[i-1].Elastic,' ',Material[i-1].PossionRate,
            ' ',Material[i-1].UnitWeight);
  end;{for}
  CloseFile(F);
end;

procedure MakeDefaultTraction;
begin
  SetLength(TractionBoundary, 0);
  SetLength(TractionValue, 0);
end;{procedure MakeDefaultTraction}

procedure LoadTraction(PathName: string);
{assumption: 1)PathName is full path and file name without extension
             2)file "PathName+'.trc'" exists and it is not empty
             3)NumRow, YLinearIndex are assigned correctly
 post:  fully assign TractionValue and TractionBoundary }
var
  F: TextFile;
  i,l:Integer;
begin
  AssignFile(F, PathName+'.trc');
 {Find how many lines there in file}
  reset(F);
  l:=0;
  while not SeekEof(F) do begin
    readln(F);
    l:=l+1;
  end;{while}
 {Read Content of the file in}
  SetLength(TractionBoundary, l);
  SetLength(TractionValue, l);
  reset(F);
  for i:=1 to l do begin
    readln(F, TractionBoundary[i-1].StartNode, TractionBoundary[i-1].EndNode,
              TractionValue[i-1].Pressure, TractionValue[i-1].Shear);
  end;{for}
  CloseFile(F);
  //assign the two "MSequence" and "ESequence"
  for i:= 1 to l do begin
    GetSequence(NumRow+1,
                TractionBoundary[i-1].StartNode,
                TractionBoundary[i-1].EndNode,
                TractionBoundary[i-1].MSequence);
    GetSequence(YLinearIndex[length(YLinearIndex)-1].EIndex,
                UNodeM[TractionBoundary[i-1].StartNode-1].uneIndex,
                UNodeM[TractionBoundary[i-1].EndNode-1].uneIndex,
                TractionBoundary[i-1].ESequence);
    GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
                UNodeE[UNodeM[TractionBoundary[i-1].StartNode-1].uneIndex-1],
                UNodeE[UNodeM[TractionBoundary[i-1].EndNode-1].uneIndex-1],
                TractionBoundary[i-1].SSequence);
  end;
end;{procedure LoadTraction}

procedure SaveTraction(PathName: string);
{assumption: PathName have valid path}
var
  F: TextFile;
  i,l: Integer;
begin
  AssignFile(F, PathName+'.trc');
  rewrite(F);
  l:=Length(TractionBoundary);
  for i:= 1 to l do begin
    writeln(F, TractionBoundary[i-1].StartNode,
          ' ',TractionBoundary[i-1].EndNode,
          ' ',TractionValue[i-1].Pressure,
          ' ',TractionValue[i-1].Shear);
  end;{for}
  CloseFile(F);
end;{procedure SaveTraction}

procedure MakeDefaultKinmat;
begin
  SetLength(KinmatBoundary,0);
  SetLength(KinmatValue, 0);
end;{procedure MakeDefaultKinmat}

procedure LoadKinmat(PathName: string);
{assumption: 1)PathName is full path and file name without extension
             2)file "PathName+'.trc'" exists and it is not empty
 post:  fully assign KinmatBoundary and KinmatValue }
var
  F: TextFile;
  i,l:Integer;
begin
  AssignFile(F, PathName+'.kin');
 {Find how many lines there in file}
  reset(F);
  l:=0;
  while not SeekEof(F) do begin
    readln(F);
    l:=l+1;
  end;{while}
 {Read Content of the file in}
  SetLength(KinmatBoundary, l);
  SetLength(KinmatValue, 1);
  reset(F);
  for i:=1 to l do begin
    readln(F, KinmatBoundary[i-1].StartNode,
              KinmatBoundary[i-1].EndNode,
              KinmatValue[i-1].iu,
              KinmatValue[i-1].iv,
              KinmatValue[i-1].XDeformation,
              KinmatValue[i-1].YDeformation);
  end;{for}
  CloseFile(F);
  //assign the two "MSequence" and "ESequence"
  for i:= 1 to l do begin
    GetSequence(NumRow+1,
                KinmatBoundary[i-1].StartNode,
                KinmatBoundary[i-1].EndNode,
                KinmatBoundary[i-1].MSequence);
    GetSequence(YLinearIndex[length(YLinearIndex)-1].EIndex,
                UNodeM[KinmatBoundary[i-1].StartNode-1].uneIndex,
                UNodeM[KinmatBoundary[i-1].EndNode-1].uneIndex,
                KinmatBoundary[i-1].ESequence);
    GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
                UNodeE[UNodeM[KinmatBoundary[i-1].StartNode-1].uneIndex-1],
                UNodeE[UNodeM[KinmatBoundary[i-1].EndNode-1].uneIndex-1],
                KinmatBoundary[i-1].SSequence);
  end;{for}
end;{procedure LoadKinmat}

procedure SaveKinmat(PathName: string);
{assumption: PathName have valid path}
var
  F: TextFile;
  i,l: Integer;
begin
  AssignFile(F, PathName+'.kin');
  rewrite(F);
  l:=Length(KinmatBoundary);
  for i:= 1 to l do begin
    writeln(F, KinmatBoundary[i-1].StartNode,
           ' ',KinmatBoundary[i-1].EndNode,
           ' ',KinmatValue[i-1].iu,
           ' ',KinmatValue[i-1].iv,
           ' ',KinmatValue[i-1].XDeformation,
           ' ',KinmatValue[i-1].YDeformation);
  end;{for}
  CloseFile(F);
end;{procedure SaveTraction}

procedure MakeMasterOutBoundary;
{assumption:1) UBlockM, Material are assigned
            2) all available blocks make a chunck together
 post: Assign MasterBoundary array, the unmIndex fields are
       arranged in the counter-clock-wise order}
var
  i, head, current, NumOfNodesInBoundary: Integer;
begin
  head:= GetMasterOutBoundaryNode;
  if head>0 then begin
   //  find NumOfNodesInBoundary and set the length of
   //MasterBoundary
    NumOfNodesInBoundary:= 1;
    current:= GetNextMasterOutBoundaryNode(head);
    while current<>head do begin
      NumOfNodesInBoundary:= NumOfNodesInBoundary+1;
      current:= GetNextMasterOutBoundaryNode(current);
    end;{while}
    SetLength(MasterOutBoundary, NumOfNodesInBoundary);
   //assign "unbIndex" field of MasterBoundary
    current:= head;
    for i:= 1 to NumOfNodesInBoundary do begin
      MasterOutBoundary[i-1].ubnIndex:=current;
      current:= GetNextMasterOutBoundaryNode(current);
    end;{for}
  end else begin
   //exception 
  end;{if}
end;{procedure MakeMasterOutBoundary}

end.


