unit BoundaryViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ComCtrls, Menus, StdCtrls, ConvLib, Extctrls;

type
  TBoundaryViewerForm = class(TForm)
    MainMenu1: TMainMenu;
    ViewMenu: TMenuItem;
    ReloadMenuItem: TMenuItem;
    BVPageControl: TPageControl;
    TrcPage: TTabSheet;
    KinPage: TTabSheet;
    StringGrid_trc: TStringGrid;
    StringGrid_kin: TStringGrid;
    OKButton: TButton;
    CancelButton: TButton;
    ModifyButton: TButton;
    trcDeleteButton: TButton;
    trcAddButton: TButton;
    kinDeleteButton: TButton;
    kinAddButton: TButton;
    OKandDismissButton: TButton;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure trcAddButtonClick(Sender: TObject);
    procedure kinAddButtonClick(Sender: TObject);
    procedure trcDeleteButtonClick(Sender: TObject);
    procedure kinDeleteButtonClick(Sender: TObject);
    procedure ModifyButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OKandDismissButtonClick(Sender: TObject);
  private
    { Private declarations }
    function trcGridTypeValid: Boolean;
    function kinGridTypeValid: Boolean;
  public
    { Public declarations }
  end;

var
  BoundaryViewerForm: TBoundaryViewerForm;

implementation

uses
  MainControl;
  
{$R *.DFM}

procedure TBoundaryViewerForm.ReloadMenuItemClick(Sender: TObject);
var
  i: Integer;
begin
  if not MainControlForm.StructureLoaded then begin
   //disable the controls which should be disabled
    ViewMenu.Enabled:= False;
    BVPageControl.Enabled:= False;
    trcAddButton.Enabled:= False;
    trcDeleteButton.Enabled:= False;
    kinAddButton.Enabled:= False;
    kinDeleteButton.Enabled:= False;
    ModifyButton.Enabled:= False;
    OKButton.Enabled:= False;
    OKandDismissButton.Enabled:= False;
    CancelButton.Enabled:= False;
   //set the state of grids
    StringGrid_trc.RowCount:= 2;
    SetStringGrid(StringGrid_trc, False, bsSingle, 0, clGrayText);
    StringGrid_kin.RowCount:= 2;
    SetStringGrid(StringGrid_kin, False, bsSingle, 0, clGrayText);
  end else begin
   //disable what should be disable
    OKButton.Enabled:= False;
    OKandDismissButton.Enabled:= False;
    CancelButton.Enabled:= False;
    trcAddButton.Enabled:= False;
    trcDeleteButton.Enabled:= False;
    kinAddButton.Enabled:= False;
    kinDeleteButton.Enabled:= False;
   //load the data of traction
    StringGrid_trc.Rows[0].CommaText:='Index,StartNode,EndNode,Pressure,Shear';
    if length(TractionBoundary)=0 then begin
      SetStringGrid(StringGrid_trc, False, bsSingle, 0, clWindowText);
      StringGrid_trc.RowCount:= 2;
      StringGrid_trc.Rows[1].CommaText:= '';
    end else begin
      SetStringGrid(StringGrid_trc, False, bsSingle, 1, clWindowText);
      StringGrid_trc.RowCount:= 1+length(TractionBoundary);
      for i:= 1 to length(TractionBoundary) do begin
        StringGrid_trc.Cells[0,i]:=IntToStr(i);
        StringGrid_trc.Cells[1,i]:=IntToStr(TractionBoundary[i-1].StartNode);
        StringGrid_trc.Cells[2,i]:=IntToStr(TractionBoundary[i-1].EndNode);
        StringGrid_trc.Cells[3,i]:=FloatToStr(TractionValue[i-1].Pressure);
        StringGrid_trc.Cells[4,i]:=FloatToStr(TractionValue[i-1].Shear);
      end; {for i:= 1 to length(TractionBoundary)}
    end;{if length(TractionBoundary}
   //load the data of kinmat
    StringGrid_kin.Rows[0].CommaText:=
      'Index,StartNode,EndNode,iu,iv,XDeformation,YDeformation';
    if length(KinmatBoundary)=0 then begin
      SetStringGrid(StringGrid_kin, False, bsSingle, 0, clWindowText);
      StringGrid_kin.RowCount:= 2;
      StringGrid_kin.Rows[1].CommaText:= '';
    end else begin
      SetStringGrid(StringGrid_kin, False, bsSingle, 1, clWindowText);
      StringGrid_kin.RowCount:= 1+length(KinmatBoundary);
      for i:= 1 to length(KinmatBoundary) do begin
        StringGrid_kin.Cells[0,i]:=IntToStr(i);
        StringGrid_kin.Cells[1,i]:=IntToStr(KinmatBoundary[i-1].StartNode);
        StringGrid_kin.Cells[2,i]:=IntToStr(KinmatBoundary[i-1].EndNode);
        StringGrid_kin.Cells[3,i]:=FloatToStr(KinmatValue[i-1].iu);
        StringGrid_kin.Cells[4,i]:=FloatToStr(KinmatValue[i-1].iv);
        StringGrid_kin.Cells[5,i]:=FloatToStr(KinmatValue[i-1].XDeformation);
        StringGrid_kin.Cells[6,i]:=FloatToStr(KinmatValue[i-1].YDeformation);
      end; {for i:= 1 to length(KinmatBoundary)}
    end;{if length(KinmatBoundary}
   //enable what should be enabled except *DeleteButton
    ViewMenu.Enabled:= True;
    ModifyButton.Enabled:= True;
    BVPageControl.Enabled:= True;
  end;{if StructureLoaded}
end;{procedure ReloadMenuItemClick}

procedure TBoundaryViewerForm.trcAddButtonClick(Sender: TObject);
var i: Integer;
begin
  if not trcDeleteButton.Enabled then begin
    StringGrid_trc.RowCount:= 2;
    SetStringGrid(StringGrid_trc, True, bsSingle, 1, clWindowText);
    StringGrid_trc.Cells[0,1]:= '1';
  end else begin
    StringGrid_trc.RowCount:= 1+StringGrid_trc.RowCount;
    for i:= (StringGrid_trc.RowCount-2) downto StringGrid_trc.Row do begin
      StringGrid_trc.Rows[i+1]:= StringGrid_trc.Rows[i];
      StringGrid_trc.Cells[0, i+1]:= IntToStr(i+1);
    end;{for i}
    StringGrid_trc.Rows[StringGrid_trc.Row].CommaText:='';
    StringGrid_trc.Cells[0, StringGrid_trc.Row]:= IntToStr(StringGrid_trc.Row);
  end;{if length(TractionBoundary)}
  trcDeleteButton.Enabled:= True;
end; {procedure trcAddButtonClick}

procedure TBoundaryViewerForm.kinAddButtonClick(Sender: TObject);
var i: Integer;
begin
  if not kinDeleteButton.Enabled then begin
    StringGrid_kin.RowCount:= 2;
    SetStringGrid(StringGrid_kin, True, bsSingle, 1, clWindowText);
    StringGrid_kin.Cells[0,1]:= '1';
  end else begin
    StringGrid_kin.RowCount:= 1+StringGrid_kin.RowCount;
    for i:= (StringGrid_kin.RowCount-2) downto StringGrid_kin.Row do begin
      StringGrid_kin.Rows[i+1]:= StringGrid_kin.Rows[i];
      StringGrid_kin.Cells[0, i+1]:= IntToStr(i+1);
    end;{for i}
    StringGrid_kin.Rows[StringGrid_kin.Row].CommaText:='';
    StringGrid_kin.Cells[0, StringGrid_kin.Row]:= IntToStr(StringGrid_kin.Row);
  end;{if length(KinmatBoundary)}
  kinDeleteButton.Enabled:= True;
end; {procedure kinAddButtonClick}

procedure TBoundaryViewerForm.trcDeleteButtonClick(Sender: TObject);
var i: Integer;
begin
  if StringGrid_trc.RowCount>2 then begin
    for i:= (StringGrid_trc.Row+1) to (StringGrid_trc.RowCount-1) do begin
      StringGrid_trc.Rows[i-1]:= StringGrid_trc.Rows[i];
      StringGrid_trc.Cells[0, i-1]:= IntToStr(i-1);
    end;{for i}
    StringGrid_trc.RowCount:= StringGrid_trc.RowCount - 1;
  end else if StringGrid_trc.RowCount=2 then begin
    trcDeleteButton.Enabled:= False;
    SetStringGrid(StringGrid_trc, False, bsSingle, 0, clWindowText);
    StringGrid_trc.RowCount:= 2;
    StringGrid_trc.Rows[1].CommaText:= '';
  end; {if StringGrid_trc.RowCount}
end;{procedure trcDeleteButtonClick}

procedure TBoundaryViewerForm.kinDeleteButtonClick(Sender: TObject);
var i: Integer;
begin
  if StringGrid_kin.RowCount>2 then begin
    for i:= (StringGrid_kin.Row+1) to (StringGrid_kin.RowCount-1) do begin
      StringGrid_kin.Rows[i-1]:= StringGrid_kin.Rows[i];
      StringGrid_kin.Cells[0, i-1]:= IntToStr(i-1);
    end;{for i}
    StringGrid_kin.RowCount:= StringGrid_kin.RowCount - 1;
  end else if StringGrid_kin.RowCount=2 then begin
    kinDeleteButton.Enabled:= False;
    SetStringGrid(StringGrid_kin, False, bsSingle, 0, clWindowText);
    StringGrid_kin.RowCount:= 2;
    StringGrid_kin.Rows[1].CommaText:= '';
  end; {if StringGrid_kin.RowCount}
end;{procedure kinDeleteButtonClick}

procedure TBoundaryViewerForm.ModifyButtonClick(Sender: TObject);
begin
if ModifyingMode then begin
  ShowMessage('Please finish the current editing');
  exit;
end;{if ModifyingMode}
if AnalyzingMode then begin
  ShowMessage('Structure cannot be modified in Analyzing mode');
  exit;
end;{if AnalyzingMode}
 //disable what should be disabled
  ModifyButton.Enabled:= False;
  ViewMenu.Enabled:= False;
 //enable what should be enabled
  OKButton.Enabled:= True;
  CancelButton.Enabled:= True;
  trcAddButton.Enabled:= True;
  kinAddButton.Enabled:= True;
  if length(TractionBoundary)>0 then begin
    trcDeleteButton.Enabled:= True;
    SetStringGrid(StringGrid_trc, True, bsSingle, 1, clWindowText);
  end;
  if length(KinmatBoundary)>0 then begin
    kinDeleteButton.Enabled:= True;
    SetStringGrid(StringGrid_kin, True, bsSingle, 1, clWindowText);
  end;
 //change the state variables
  ModifyingMode:= True;
 //change message
  MainControlForm.MessageLabel.Caption:=
    'Message: Editing boundaries';
MainControlForm.GoModifyingMode;
end;{procedure ModifyButtonClick}

procedure TBoundaryViewerForm.OKButtonClick(Sender: TObject);
{assumpution: StructureLoaded}
var
  tmpTrc, tmpKin : array of TBoundary;
  i: Integer;
  trcValidFlag, kinValidFlag: Integer;
begin          
 //do the basic type check
  if not (trcGridTypeValid and kinGridTypeValid) then begin
    ShowMessage('Invalid input for boundaries');
    exit;
  end;{if trcGridTypeValid kinGridTypeValid}
 //build the tmp boundary arrays for testing
  if trcDeleteButton.Enabled then begin
    SetLength(tmpTrc, StringGrid_trc.RowCount-1);
    for i:= 1 to (StringGrid_trc.RowCount-1) do begin
      tmpTrc[i-1].StartNode:= StrToInt(StringGrid_trc.Cells[1,i]);
      tmpTrc[i-1].EndNode  := StrToInt(StringGrid_trc.Cells[2,i]);
      GetSequence(NumRow+1, tmpTrc[i-1].StartNode,
                  tmpTrc[i-1].EndNode, tmpTrc[i-1].MSequence);
      GetSequence(YLinearIndex[length(YLinearIndex)-1].EIndex,
                  UNodeM[tmpTrc[i-1].StartNode-1].uneIndex,
                  UNodeM[tmpTrc[i-1].EndNode-1].uneIndex,
                  tmpTrc[i-1].ESequence);
      GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
                  UNodeE[UNodeM[tmpTrc[i-1].StartNode-1].uneIndex-1],
                  UNodeE[UNodeM[tmpTrc[i-1].EndNode-1].uneIndex-1],
                  tmpTrc[i-1].SSequence);
    end;{for i}
  end else begin
    SetLength(tmpTrc, 0);
  end;{if trcDeleteButton.Enabled}
  if kinDeleteButton.Enabled then begin
    SetLength(tmpKin, StringGrid_kin.RowCount-1);
    for i:= 1 to (StringGrid_kin.RowCount-1) do begin
      tmpKin[i-1].StartNode:= StrToInt(StringGrid_kin.Cells[1,i]);
      tmpKin[i-1].EndNode  := StrToInt(StringGrid_kin.Cells[2,i]);
      GetSequence(NumRow+1, tmpKin[i-1].StartNode,
                  tmpKin[i-1].EndNode, tmpKin[i-1].MSequence);
      GetSequence(YLinearIndex[length(YLinearIndex)-1].EIndex,
                  UNodeM[tmpKin[i-1].StartNode-1].uneIndex,
                  UNodeM[tmpKin[i-1].EndNode-1].uneIndex,
                  tmpKin[i-1].ESequence);
      GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
                  UNodeE[UNodeM[tmpKin[i-1].StartNode-1].uneIndex-1],
                  UNodeE[UNodeM[tmpKin[i-1].EndNode-1].uneIndex-1],
                  tmpKin[i-1].SSequence);
    end;{for i}
  end else begin
    SetLength(tmpKin, 0);
  end;{if kinDeleteButton.Enabled}
 //check if the tmp boundary arrays are valid and do operations
  trcValidFlag:= BoundaryValid(tmpTrc);
  kinValidFlag:= BoundaryValid(tmpKin);
  if     ((trcValidFlag=2)or(trcValidFlag=1))
     and ((kinValidFlag=2)or(kinValidFlag=1)) then begin
   //disable what should be disabled
    if trcDeleteButton.Enabled then
         SetStringGrid(StringGrid_trc, False, bsSingle, 1, clGrayText)
    else SetStringGrid(StringGrid_trc, False, bsSingle, 0, clGrayText);
    if kinDeleteButton.Enabled then
         SetStringGrid(StringGrid_kin, False, bsSingle, 1, clGrayText)
    else SetStringGrid(StringGrid_kin, False, bsSingle, 0, clGrayText);
    OKButton.Enabled:= False;
    OKandDismissButton.Enabled:= False;
    CancelButton.Enabled:= False;
    trcAddButton.Enabled:= False;
    trcDeleteButton.Enabled:= False;
    kinAddButton.Enabled:= False;
    kinDeleteButton.Enabled:= False;
   //update the boundaries
    SetLength(TractionBoundary, length(tmpTrc));
    SetLength(TractionValue, length(TractionBoundary));
    for i:= 1 to length(tmpTrc) do begin
      TractionBoundary[i-1].StartNode:= tmpTrc[i-1].StartNode;
      TractionBoundary[i-1].EndNode:= tmpTrc[i-1].EndNode;
      TractionBoundary[i-1].MSequence:=
          Copy(tmpTrc[i-1].MSequence, 0, length(tmpTrc[i-1].MSequence));
      TractionBoundary[i-1].ESequence:=
          Copy(tmpTrc[i-1].ESequence, 0, length(tmpTrc[i-1].ESequence));
      GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
          UNodeE[UNodeM[TractionBoundary[i-1].StartNode-1].uneIndex-1],
          UNodeE[UNodeM[TractionBoundary[i-1].EndNode-1].uneIndex-1],
          TractionBoundary[i-1].SSequence);
      TractionValue[i-1].Pressure:= StrToFloat(StringGrid_trc.Cells[3,i]);
      TractionValue[i-1].Shear   := StrToFloat(StringGrid_trc.Cells[4,i]);
    end;{for i}
    SetLength(KinmatBoundary, length(tmpKin));
    SetLength(KinmatValue, length(KinmatBoundary));
    for i:= 1 to length(tmpKin) do begin
      KinmatBoundary[i-1].StartNode:= tmpKin[i-1].StartNode;
      KinmatBoundary[i-1].EndNode:= tmpKin[i-1].EndNode;
      KinmatBoundary[i-1].MSequence:=
          Copy(tmpKin[i-1].MSequence, 0, length(tmpKin[i-1].MSequence));
      KinmatBoundary[i-1].ESequence:=
          Copy(tmpKin[i-1].ESequence, 0, length(tmpKin[i-1].ESequence));
      GetSequence(YLinearIndex[length(YLinearIndex)-1].SIndex,
          UNodeE[UNodeM[KinmatBoundary[i-1].StartNode-1].uneIndex-1],
          UNodeE[UNodeM[KinmatBoundary[i-1].EndNode-1].uneIndex-1],
          KinmatBoundary[i-1].SSequence);
      KinmatValue[i-1].iu:= StrToInt(StringGrid_kin.Cells[3,i]);
      KinmatValue[i-1].iv:= StrToInt(StringGrid_kin.Cells[4,i]);
      KinmatValue[i-1].XDeformation:= StrToFloat(StringGrid_kin.Cells[5,i]);
      KinmatValue[i-1].YDeformation:= StrToFloat(StringGrid_kin.Cells[6,i]);
    end;{for i}
   //deallocate tmp*
    tmpTrc:= nil;
    tmpKin:= nil;
   //enable what should be enabled
    ViewMenu.Enabled:= True;
    ModifyButton.Enabled:=True;
   //change other state variables
    MainControlForm.StructureSaved:= False;
    MainControlForm.LeaveModifyingMode;
    ForcedBoundaryModify:= False;
   //reload other components
    MainControlForm.ReloadAll(BoundaryViewerForm); 
   //change message
    MainControlForm.MessageLabel.Caption:=
      'Message:';
  end else begin
    ShowMessage('invalid boundary exist');
    exit;
  end;{if trcValidFlag kinValidFlag}
end;{procedure OKButtonClick}

function TBoundaryViewerForm.trcGridTypeValid: Boolean;
{assumption: UNodeM is assigned correctly}
var i, n: Integer;
begin
  trcGridTypeValid:= True;
  if BoundaryViewerForm.trcDeleteButton.Enabled then begin
  with BoundaryViewerForm.StringGrid_trc do begin
   //check basic data type
    for i:= 1 to (RowCount-1) do begin
      if not(    StrCanToPosI(Cells[1,i])
             and StrCanToPosI(Cells[2,i])
             and StrCanToFloat(Cells[3,i])
             and StrCanToFloat(Cells[4,i])  ) then
      begin
        trcGridTypeValid:= False;
        Exit;
      end;{if}
    end;{for i}
   //check the range of nodes
    n:= length(UNodeM);
    for i:= 1 to (RowCount-1) do begin
      if not(     (Cells[1,i]<>Cells[2,i])
              and (StrToInt(Cells[1,i]) in [1..n])
              and (StrToInt(Cells[2,i]) in [1..n])  ) then
      begin
        trcGridTypeValid:= False;
        Exit;
      end;{if}
    end;{for i}
  end;{with StringGrid_trc}
  end;{if traction data is not empty}
end;{function trcGridTypeValid}

function TBoundaryViewerForm.kinGridTypeValid: Boolean;
{assumption: UNodeM is assigned correctly}
var i, n: Integer;
begin
  kinGridTypeValid:= True;
  if BoundaryViewerForm.kinDeleteButton.Enabled then begin
  with BoundaryViewerForm.StringGrid_kin do begin
   //check basic data type
    for i:= 1 to (RowCount-1) do begin
      if not(    StrCanToPosI(Cells[1,i])
             and StrCanToPosI(Cells[2,i])
             and ( (Cells[3,i]='0') or (Cells[3,i]='1') )
             and ( (Cells[4,i]='0') or (Cells[4,i]='1') )
             and StrCanToFloat(Cells[5,i])
             and StrCanToFloat(Cells[6,i])  ) then
      begin
        kinGridTypeValid:= False;
        Exit;
      end;{if}
    end;{for i}
   //check the range of nodes
    n:= length(UNodeM);
    for i:= 1 to (RowCount-1) do begin
      if not(     (Cells[1,i]<>Cells[2,i])
              and (StrToInt(Cells[1,i]) in [1..n])
              and (StrToInt(Cells[2,i]) in [1..n])  ) then
      begin
        kinGridTypeValid:= False;
        Exit;
      end;{if}
    end;{for i}
  end;{with StringGrid_kin}
  end;{if kinmat data is not empty}
end;{function kinGridTypeValid}

procedure TBoundaryViewerForm.CancelButtonClick(Sender: TObject);
begin
  if ForcedBoundaryModify then begin
    ShowMessage('This Modification of Boundary cannot be cancelled'
                +#13+'because you just modified the existing blocks');
  end else begin
    BoundaryViewerForm.ReloadMenuItemClick(nil);
    MainControlForm.LeaveModifyingMode;
  end;
end;

procedure TBoundaryViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  if BoundaryViewerForm.ModifyButton.Enabled
  or (not MainControlForm.StructureLoaded) then begin
    BoundaryViewerVisible:= False;
    MainControlForm.BoundaryViewerMenuItem.Checked:= False;
    BoundaryViewerForm.Visible:= False;
    MainControlForm.MessageLabel.Caption:=
      'Message:';
  end else begin
    MessageDlg('Please finish editing before closeing',
               mtInformation, [mbOK], 0);
  end;{if}
end;

procedure TBoundaryViewerForm.OKandDismissButtonClick(Sender: TObject);
var ca: TCloseAction;
begin
  if BoundaryViewerForm.OKButton.Enabled then OKButtonClick(nil);
  FormClose(nil, ca);
end;

end.
