unit AnalyzeResultViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Math, ConvLib, OpenGL, AnalyzeLib, ExtCtrls;

type
  TAnalyzeResultViewerForm = class(TForm)
    AnalyzeResultViewerMainMenu: TMainMenu;
    ViewMenu: TMenuItem;
    ReloadMenuItem: TMenuItem;
    N1: TMenuItem;
    ZoomInMenuItem: TMenuItem;
    ZoomOutMenuItem: TMenuItem;
    UnZoomMenuItem: TMenuItem;
    N2: TMenuItem;
    IndexingSelectionMenuItem: TMenuItem;
    CoordinateMenuItem: TMenuItem;
    NoneMenuItemLV2: TMenuItem;
    NodeMenuItemLV2: TMenuItem;
    PieceMenuItemLV2: TMenuItem;
    N3: TMenuItem;
    ChangeXYUnitScaleRatio: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure ZoomInMenuItemClick(Sender: TObject);
    procedure ZoomOutMenuItemClick(Sender: TObject);
    procedure UnZoomMenuItemClick(Sender: TObject);
    procedure CoordinateMenuItemClick(Sender: TObject);
    procedure NoneMenuItemLV2Click(Sender: TObject);
    procedure NodeMenuItemLV2Click(Sender: TObject);
    procedure PieceMenuItemLV2Click(Sender: TObject);
    procedure ChangeXYUnitScaleRatioClick(Sender: TObject);
  private
    { Private declarations }
    procedure PaintNum(X, Y: Real; Num: PChar);
    procedure InitOpenGL;
    procedure SetCriticalValues;
    procedure DrawScene;
  public
    { Public declarations }
  end;

var
  AnalyzeResultViewerForm: TAnalyzeResultViewerForm;

implementation
uses
  MainControl;
type
  TindexEnmu=(objNODE, objPIECE,objNONE);
var
  //for menu items
  resultCoordinated: Boolean;
  IndexSelect: TindexEnmu;
  //for display dimensions--global info
  MinX, MaxX, MinY, MaxY, StructureWidth, StructureHeight: Real;
  MarginRatio: Real;
  XYUnitScaleRatio: real;
  XYClientRatio: Real;
  //for the result of analyzing
  MinFcnVal, MaxFcnVal: real;
  //for display dimensions--local info
  mouseL: Boolean;
  XDisplayRange,YDisplayRange: Real;
  LeftDisplayEdge, RightDisplayEdge, LowDisplayEdge, HighDisplayEdge: Real;
  OldLeftDisplayEdge, OldRightDisplayEdge,
  OldLowDisplayEdge, OldHighDisplayEdge: Real;
  //for draging
  tailX, tailY: Integer;
  //for character rendering
  xShift, yShift: Real;
  CharSize: Integer;
  CusFont: TFont;
  //colors of diferent objects
  rNodeColor, rLineColor: GLclampf;
  gNodeColor, gLineColor: GLclampf;
  bNodeColor, bLineColor: GLclampf;
  aNodeColor, aLineColor: GLclampf;
  rBackGroundColor, rCoordColor, rIndexColor: GLclampf;
  gBackGroundColor, gCoordColor, gIndexColor: GLclampf;
  bBackGroundColor, bCoordColor, bIndexColor: GLclampf;
  aBackGroundColor, aCoordColor, aIndexColor: GLclampf;

{$R *.DFM}

procedure finderr;
var
  errorcode: GLenum;
begin
  errorcode:= glGetError;
  if errorcode<>GL_NO_ERROR then
    MessageDlg('glerr:'+ gluErrorString(errorcode),
               mtInformation, [mbOK], 0);
end;

procedure TAnalyzeResultViewerForm.PaintNum(X, Y: Real; Num: PChar);
{assumption: 1) Num is only formed by digits '0' to '9' and some
                characters
             2) list base is setup properly }
var l: Integer;
begin
  l:= Length(Num);
  glRasterPos3f(X, Y, 0.2);
  glCallLists(l, GL_UNSIGNED_BYTE, Num);
end;

procedure TAnalyzeResultViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action:= caNone;
  ShowMessage('This window cannot be closed in analyzing mode');
end;

procedure TAnalyzeResultViewerForm.FormCreate(Sender: TObject);
begin
 //Initialize all the state variables
   //colors
   rLineColor:=0.1;
   gLineColor:=0.1;
   bLineColor:=0.1;
   aLineColor:=1.0;     //dark gray
   rNodeColor:=0.0;
   gNodeColor:=0.6;
   bNodeColor:=0.0;
   aNodeColor:=1.0;    //dark green
   rBackGroundColor:=0.8;
   gBackGroundColor:=0.8;
   bBackGroundColor:=0.8;
   aBackGroundColor:=1.0;     //bright gray
   rCoordColor:=0.0;
   gCoordColor:=0.6;
   bCoordColor:=0.0;
   aCoordColor:=1.0;      //dark green
   rIndexColor:=0.0;
   gIndexColor:=0.0;
   bIndexColor:=1.0;
   aIndexColor:=1.0;     //blue
   //Dimensions
     {MinX,MaxX,MinY,MaxY,xShift,yShift,XYClientRatio
      are not initialized here}
   XYUnitScaleRatio:= 1;
   MarginRatio:= 0.1;
   //variables related to menu
   resultCoordinated:= False;
   IndexSelect:= objNODE;
   //state variables related to draging
   mouseL:= False;
   //other
   CharSize:= 6;

   AnalyzeResultViewerForm.ClientWidth:= 250;
   AnalyzeResultViewerForm.ClientWidth:= 300;
end;{procedure FormCreate}

procedure TAnalyzeResultViewerForm.InitOpenGL;
{assumption: The related variables are initialized by FromCreate}
var
  pfd: TPixelFormatDescriptor;
  FormatIndex: integer;
begin
if OpenGLReady then begin
  wglMakeCurrent(glDC,0);
  wglDeleteContext(GLContext);
  OpenGLReady:= false;
end;
 //the contexts
  fillchar(pfd, SizeOf(pfd),0);
  with pfd do
  begin
    nSize := sizeOf(pfd);
    nVersion := 1;
    dwFlags := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL;
    iPixelType := PFD_TYPE_RGBA;
    cColorBits := 24;
    cDepthBits := 32;
    iLayerType := PFD_MAIN_PLANE;
  end;{with}
  glDC:= getDC(AnalyzeResultViewerForm.Handle);
  FormatIndex := ChoosePixelFormat(glDC,@pfd);
  SetPixelFormat(glDC,FormatIndex, @pfd);
  GLContext := wglCreateContext(glDC);
  wglMakeCurrent(glDC, GLContext);
 //the character bitmaps
  CusFont:= TFont.Create;
  CusFont.Height:= CharSize;
  SelectObject(glDC, CusFont.Handle);
  wglUseFontBitmaps(glDC, 32, 26, 33);
  glListBase(1);
 //the multiple-function-color-mapping
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_CLAMP);
  glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_T, GL_CLAMP);
  glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexImage1D(GL_TEXTURE_1D, 0, GL_RGBA, 256, 0, GL_RGBA,
               GL_UNSIGNED_BYTE, MultiFcnValColorMap);
  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
 //other
  glClearColor(rBackGroundColor, gBackGroundColor,
               bBackGroundColor, aBackGroundColor);
  glEnable(GL_DEPTH_TEST);
  finderr;
  OpenGLReady:= True;
end;{procedure InitOpenGL}


procedure TAnalyzeResultViewerForm.SetCriticalValues;
{assumption: 1) IEL, Nodes, MultiFcnFloat, SelectedMultiFcnFloat
                are assigned
 post:1) set up these variables for displaying, which is not going
         to change until:
         MinX, MaxX, MinY, MaxY, XYClientRatio, xShift, yShift,
         SceneWidth, SceneHeight
      2) initialize up these variables for being modified when drag/zoom:
         LeftDisplayEdge, RightDisplayEdge, LowDisplayEdge,
         HighDisplayEdge   }
var
  i, n: Integer;
begin
 //get MinX, MaxX, MinY, MaxY, MinFcnVal, MaxFcnVal
  n:= length(Nodes);
  if n= 0 then begin
    //this is a special case
    MinX:= 0; MaxX:= 0; MinY:= 0; MaxY:= 0;
    MinFcnVal:= 0; MaxFcnVal:= 0;
  end else begin
    MinX:= Nodes[0].X; MaxX:= Nodes[0].X;
    MinY:= Nodes[0].Y; MaxY:= Nodes[0].Y;
    MinFcnVal:= (MultiFcnData[0])[SelectedMultiFcnData-1];
    MaxFcnVal:= (MultiFcnData[0])[SelectedMultiFcnData-1];
    for i:= 2 to n do begin
      if MinX>Nodes[i-1].X then begin
        MinX:= Nodes[i-1].X;
      end else if MaxX<Nodes[i-1].X then begin
        MaxX:= Nodes[i-1].X;
      end;{if MinX MaxX}
      if MinY>Nodes[i-1].Y then begin
        MinY:= Nodes[i-1].Y;
      end else if MaxY<Nodes[i-1].Y then begin
        MaxY:= Nodes[i-1].Y;
      end;{if MinY maxY}
      if MinFcnVal>((MultiFcnData[i-1])[SelectedMultiFcnData-1]) then begin
        MinFcnVal:= ((MultiFcnData[i-1])[SelectedMultiFcnData-1]);
      end else if MaxFcnVal<((MultiFcnData[i-1])[SelectedMultiFcnData-1])
      then begin
        MaxFcnVal:= ((MultiFcnData[i-1])[SelectedMultiFcnData-1]);
      end;{if MinFcnVal MaxFcnVal}
    end;{for 1 to number of nodes}
  end;{num of nodes}
 //get StructureWidth, StructureHeight, XYClientRatio
  StructureWidth:= MaxX-MinX;
  StructureHeight:= MaxY-MinY;
  XYClientRatio:= XYUnitScaleRatio*(StructureWidth/StructureHeight);
 //get xShift, yShift
  xShift:= StructureWidth/75;
  yShift:= StructureHeight/75;
 //initialize the display edges and display ranges
  LeftDisplayEdge:=MinX-MarginRatio*StructureWidth;
  RightDisplayEdge:=MaxX+2*MarginRatio*StructureWidth;
  LowDisplayEdge:=MinY-MarginRatio*StructureHeight;
  HighDisplayEdge:=MaxY+MarginRatio*StructureHeight;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;    
end;{procedure SetCriticalValues}


procedure TAnalyzeResultViewerForm.FormDestroy(Sender: TObject);
begin
  if OpenGLReady then begin
    wglMakeCurrent(glDC,0);
    wglDeleteContext(GLContext);
    OpenGLReady:= false;
  end;
end;

procedure TAnalyzeResultViewerForm.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then begin
   //this variable is kept only for flexibility
    mouseL:= True;
   //back up the state for redrawing
    tailX:= X;
    tailY:= Y;
    OldLeftDisplayEdge:= LeftDisplayEdge;
    OldRightDisplayEdge:=RightDisplayEdge;
    OldLowDisplayEdge:=LowDisplayEdge;
    OldHighDisplayEdge:=HighDisplayEdge;
  end;
end;

procedure TAnalyzeResultViewerForm.FormMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var defX,defY: real;
begin
  if MainControlForm.StructureLoaded then begin
   //redraw the scene
    defX:= XDisplayRange*(X-tailX)/ClientWidth;
    defY:= YDisplayRange*(tailY-Y)/ClientHeight;
    LeftDisplayEdge:=OldLeftDisplayEdge-defX;
    RightDisplayEdge:=OldRightDisplayEdge-defX;
    LowDisplayEdge:=OldLowDisplayEdge-defY;
    HighDisplayEdge:=OldHighDisplayEdge-defY;
    DrawScene;
   end;{if StructureLoaded}
 //no effect but kept for flexibility
  mouseL:=False;
end;

procedure TAnalyzeResultViewerForm.FormPaint(Sender: TObject);
begin
  if ((AnalyzingMode) and (MainControlForm.StructureLoaded)) then begin
    DrawScene;
  end;
end;{procedure FormPaint}

procedure TAnalyzeResultViewerForm.FormResize(Sender: TObject);
begin
  if ((AnalyzingMode) and (MainControlForm.StructureLoaded)) then begin
   //decide the dimension of AnalyzeResultViewer
    ClientWidth:= ceil(ClientHeight*XYClientRatio);
   //redraw the scene
    glViewPort(0, 0, ClientWidth, ClientHeight);
    DrawScene;
  end;
end;{procedure FormResize}

procedure TAnalyzeResultViewerForm.ReloadMenuItemClick(Sender: TObject);
begin
 //read the data files
  LoadNodes(StructureEditorPath+'\in\data.nnd');
  LoadIEL(StructureEditorPath+'\in\data.iel');
  Load2DFloats(StructureEditorPath+'\out\data.plr',
               MultiFcnData );
 //set necessary variables for displaying
  SetCriticalValues;
 //set the size of Analyze Result Viewer
  AnalyzeResultViewerForm.ClientWidth:=
    ceil(XYClientRatio*AnalyzeResultViewerForm.ClientHeight); 
 //draw the scene
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.ZoomInMenuItemClick(Sender: TObject);
var CX,CY: Real;
begin
  CX:= 0.5*(LeftDisplayEdge+RightDisplayEdge);
  CY:= 0.5*(LowDisplayEdge+HighDisplayEdge);
  LeftDisplayEdge:= CX-0.8*0.5*XDisplayRange;
  RightDisplayEdge:= CX+0.8*0.5*XDisplayRange;
  LowDisplayEdge:= CY-0.8*0.5*YDisplayRange;
  HighDisplayEdge:= CY+0.8*0.5*YDisplayRange;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.ZoomOutMenuItemClick(Sender: TObject);
var CX,CY: Real;
begin
  CX:= 0.5*(LeftDisplayEdge+RightDisplayEdge);
  CY:= 0.5*(LowDisplayEdge+HighDisplayEdge);
  LeftDisplayEdge:= CX-1.25*0.5*XDisplayRange;
  RightDisplayEdge:= CX+1.25*0.5*XDisplayRange;
  LowDisplayEdge:= CY-1.25*0.5*YDisplayRange;
  HighDisplayEdge:= CY+1.25*0.5*YDisplayRange;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.UnZoomMenuItemClick(Sender: TObject);
begin
  AnalyzeResultViewerForm.ReloadMenuItemClick(nil);
end;

procedure TAnalyzeResultViewerForm.CoordinateMenuItemClick(
  Sender: TObject);
begin
  CoordinateMenuItem.Checked:= (not (CoordinateMenuItem.Checked));
  resultCoordinated:= CoordinateMenuItem.Checked;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.NoneMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= True;
  NodeMenuItemLV2.Checked:= False;
  PieceMenuItemLV2.Checked:= False;
  IndexSelect:= objNONE;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.NodeMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= False;
  NodeMenuItemLV2.Checked:= True;
  PieceMenuItemLV2.Checked:= False;
  IndexSelect:= objNODE;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.PieceMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= False;
  NodeMenuItemLV2.Checked:= False;
  PieceMenuItemLV2.Checked:= True;
  IndexSelect:= objPIECE;
  DrawScene;
end;

procedure TAnalyzeResultViewerForm.DrawScene;
{assumption: IEL, Nodes, MultiFcnData are assigned}
var
  i, np, nn: integer;
  FcnVal: real;
  X,Y: real;
begin
 //find the number of pieces and nodes
  np:= length(IEL);
  nn:= length(Nodes);
 //initialize OpenGL
  AnalyzeResultViewerForm.InitOpenGL;
 //set the render mode for drawing
  glRenderMode(GL_RENDER);
 //clear the buffer
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
 //Model-View transformation
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  gluLookAt(0,0,1, 0,0,0, 0,1,0);
 //Projection transformation
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  glOrtho(LeftDisplayEdge, RightDisplayEdge,
          LowDisplayEdge, HighDisplayEdge,
          0, 2);
 //draw the line loops
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to np do begin
    glBegin(GL_LINE_LOOP);
      glVertex3f(Nodes[IEL[i-1].V1-1].X, Nodes[IEL[i-1].V1-1].Y, 0.1);
      glVertex3f(Nodes[IEL[i-1].V2-1].X, Nodes[IEL[i-1].V2-1].Y, 0.1);
      glVertex3f(Nodes[IEL[i-1].V3-1].X, Nodes[IEL[i-1].V3-1].Y, 0.1);
      glVertex3f(Nodes[IEL[i-1].V4-1].X, Nodes[IEL[i-1].V4-1].Y, 0.1);
      glVertex3f(Nodes[IEL[i-1].V5-1].X, Nodes[IEL[i-1].V5-1].Y, 0.1);
      glVertex3f(Nodes[IEL[i-1].V6-1].X, Nodes[IEL[i-1].V6-1].Y, 0.1);
    glEnd;
  end;
 //draw the color indicating multi-function-Data values of each node
  glEnable(GL_TEXTURE_1D);
  for i:= 1 to np do begin
    glBegin(GL_POLYGON);
      FcnVal:= MultiFcnData[IEL[i-1].V1-1][SelectedMultiFcnData-1];
      glTexCoord1f(FcnVal/(MaxFcnVal-MinFcnVal));
      glVertex3f(Nodes[IEL[i-1].V1-1].X, Nodes[IEL[i-1].V1-1].Y, 0.0);
      FcnVal:= MultiFcnData[IEL[i-1].V3-1][SelectedMultiFcnData-1];
      glTexCoord1f(FcnVal/(MaxFcnVal-MinFcnVal));
      glVertex3f(Nodes[IEL[i-1].V3-1].X, Nodes[IEL[i-1].V3-1].Y, 0.0);
      FcnVal:= MultiFcnData[IEL[i-1].V5-1][SelectedMultiFcnData-1];
      glTexCoord1f(FcnVal/(MaxFcnVal-MinFcnVal));
      glVertex3f(Nodes[IEL[i-1].V5-1].X, Nodes[IEL[i-1].V5-1].Y, 0.0);
    glEnd;
  end;
  glDisable(GL_TEXTURE_1D);
 //draw the index
  if IndexSelect=objNODE then begin
    glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
    for i:= 1 to nn do begin
      X:= Nodes[i-1].X;
      Y:= Nodes[i-1].Y;
      PaintNum( X+xShift, Y+yShift, PChar(IntToStr(i)) ); 
    end;{for 1 to number of nodes}
  end else if IndexSelect=objPIECE then begin
    glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
    for i:= 1 to np do begin
      if ((i)mod(2))=1 then begin
        X:= 0.5*( Nodes[IEL[i-1].V3-1].X + Nodes[IEL[i-1].V6-1].X );
        Y:= 0.5*( Nodes[IEL[i-1].V3-1].Y + Nodes[IEL[i-1].V6-1].Y );
      end else begin
        X:= 0.5*( Nodes[IEL[i-1].V2-1].X + Nodes[IEL[i-1].V5-1].X );
        Y:= 0.5*( Nodes[IEL[i-1].V2-1].Y + Nodes[IEL[i-1].V5-1].Y );
      end;
      PaintNum( X, Y, PChar(IntToStr(i)) );
    end;{for 1 to number of pieces}
  end; {if IndexSelect}
 //finish
  glFlush;
end;{Draw Scene}

procedure TAnalyzeResultViewerForm.ChangeXYUnitScaleRatioClick(
  Sender: TObject);
var
  tmpString: string;
begin
  tmpString:='Not A Positive Number';
  while not StrCanToPosF(tmpString) do begin
    tmpString:= InputBox('XYUnitScaleRatio Editor',
                         'New XYUnitScaleRatio: ',
                         FloatToStr(XYUnitScaleRatio));
  end;
  XYUnitScaleRatio:= StrToFloat(tmpString);
  AnalyzeResultViewerForm.ReloadMenuItemClick(nil);
end;{procedure ChangeXYUnitScaleRatioClick}

end.
