unit MainViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Math, OpenGL, ConvLib, ToolWin, ComCtrls;

type
  TMainViewerForm = class(TForm)
    MainViewerMainMenu: TMainMenu;
    ViewMenu: TMenuItem;
    N1: TMenuItem;
    NodeMenuItemLV2: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    ReloadMenuItem: TMenuItem;
    ZoomInMenuItem: TMenuItem;
    DiscardMenuItem: TMenuItem;
    ShapedMenuItem: TMenuItem;
    DivisionLevelMenuItem: TMenuItem;
    IndexSelectMenuItem: TMenuItem;
    NoneMenuItemLV2: TMenuItem;
    PieceMenuItemLV2: TMenuItem;
    MasterMenuItemLV2: TMenuItem;
    ElementMenuItemLV2: TMenuItem;
    SubElementMenuItemLV2: TMenuItem;
    CoordinateMenuItem: TMenuItem;
    ZoomOutMenuItem: TMenuItem;
    UnZoomMenuItem: TMenuItem;
    N5: TMenuItem;
    ChangeXYUnitScaleRatio: TMenuItem;
    procedure ReloadMenuItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure DrawScene;
    procedure FormResize(Sender: TObject);
    procedure ElementMenuItemLV2Click(Sender: TObject);
    procedure SubElementMenuItemLV2Click(Sender: TObject);
    procedure MasterMenuItemLV2Click(Sender: TObject);
    procedure ShapedMenuItemClick(Sender: TObject);
    procedure DiscardMenuItemClick(Sender: TObject);
    procedure CoordinateMenuItemClick(Sender: TObject);
    procedure NoneMenuItemLV2Click(Sender: TObject);
    procedure NodeMenuItemLV2Click(Sender: TObject);
    procedure PieceMenuItemLV2Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure ZoomInMenuItemClick(Sender: TObject);
    procedure ZoomOutMenuItemClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UnZoomMenuItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ChangeXYUnitScaleRatioClick(Sender: TObject);
  private
    { Private declarations }
    procedure PaintNum(X, Y: Real; Num: PChar);
    procedure SetCriticalValues;
    procedure InitOpenGL;
    procedure DrawUshapedM;
    procedure DrawUshapedE;
    procedure DrawUshapedS;
    procedure DrawDshapedM;
    procedure DrawDshapedE;
    procedure DrawDshapedS;
    procedure DrawUunshapedM;
    procedure DrawUunshapedE;
    procedure DrawUunshapedS;
    procedure DrawDunshapedM;
    procedure DrawDunshapedE;
    procedure DrawDunshapedS;
    procedure DrawHighLightBlock;
    procedure DrawTractionBoundary;
    procedure DrawKinmatBoundary;
  public
    { Public declarations }
  end;

var
  MainViewerForm: TMainViewerForm;

implementation
uses
  MainControl;
type
  TmvEnmu=(lvMASTER, lvELEMENT, lvSUBELEMENT,objNODE, objPIECE,objNONE);
var
  //for menu items
  mvShaped, mvDiscarded, mvCoordinated: Boolean;
  PlotLevel, IndexSelect: TmvEnmu;
  //for display dimensions--global info
  MinX, MaxX, MinY, MaxY, StructureWidth, StructureHeight: Real;
  MarginRatio: Real;
  XYUnitScaleRatio: Real;
  XYClientRatio: Real;
  //for display dimensions--local info
  mouseL: Boolean;
  XDisplayRange,YDisplayRange: Real;
  LeftDisplayEdge, RightDisplayEdge, LowDisplayEdge, HighDisplayEdge: Real;
  OldLeftDisplayEdge, OldRightDisplayEdge,
  OldLowDisplayEdge, OldHighDisplayEdge: Real;
  OldClientWidth, OldClientHeight: integer;
  //for draging
  tailX, tailY: Integer;
  //for character rendering
  xShift, yShift: Real;
  CharSize: Integer;
  CusFont: TFont;
  //colors of diferent objects
  rNodeColor, rLineColor, rBlockAvailColor, rBlockUnavailColor: GLclampf;
  gNodeColor, gLineColor, gBlockAvailColor, gBlockUnavailColor: GLclampf;
  bNodeColor, bLineColor, bBlockAvailColor, bBlockUnavailColor: GLclampf;
  aNodeColor, aLineColor, aBlockAvailColor, aBlockUnavailColor: GLclampf;
  rBackGroundColor, rCoordColor, rIndexColor, rSelectColor: GLclampf;
  gBackGroundColor, gCoordColor, gIndexColor, gSelectColor: GLclampf;
  bBackGroundColor, bCoordColor, bIndexColor, bSelectColor: GLclampf;
  aBackGroundColor, aCoordColor, aIndexColor, aSelectColor: GLclampf;
  rTractionColor, rKinmatColor: GLclampf;
  gTractionColor, gKinmatColor: GLclampf;
  bTractionColor, bKinmatColor: GLclampf;
  aTractionColor, aKinmatColor: GLclampf;
  //others
  XVertices,YVertices, Coners: array of Real;
  
{$R *.DFM}

procedure finderr(str: string);
var
  errorcode: GLenum;
begin
  errorcode:= glGetError;
  if errorcode<>GL_NO_ERROR then
    MessageDlg(str + ': ' + gluErrorString(errorcode),
               mtInformation, [mbOK], 0);
end;

procedure TMainViewerForm.ReloadMenuItemClick(Sender: TObject);
begin
  if (not MainControlForm.StructureLoaded) then begin
    //Disable every thing
     MainViewerForm.ViewMenu.Enabled:= False;
  end else begin
    //reset the important values
     SetCriticalValues;
    //set the height and width of Main Viewer
     MainViewerForm.ClientWidth:=
       ceil(XYClientRatio*MainViewerForm.ClientHeight);
    //render the graph
     DrawScene;
    //enable the controls which should be enabled 
     MainViewerForm.ViewMenu.Enabled:= True;
  end;
end;

procedure TMainViewerForm.PaintNum(X, Y: Real; Num: PChar);
{assumption: 1) Num is only formed by digits '0' to '9' and some
                simple characters
             2) list base is setup properly }
var l: Integer;
begin
  l:= Length(Num);
  glRasterPos3f(X, Y, 0);
  glCallLists(l, GL_UNSIGNED_BYTE, Num);
end;

procedure TMainViewerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  MainViewerVisible:= False;
  MainControlForm.MainViewerMenuItem.Checked:= False;
  MainViewerForm.Visible:= False;
end;

procedure TMainViewerForm.FormCreate(Sender: TObject);
begin
 //Initialize all the state variables
   //colors
   rBlockAvailColor:=1.0;
   gBlockAvailColor:=0.0;
   bBlockAvailColor:=0.0;
   aBlockAvailColor:=0.9;    //red
   rBlockUnavailColor:=1.0;
   gBlockUnavailColor:=1.0;
   bBlockUnavailColor:=1.0;
   aBlockUnavailColor:=0.9;  //white
   rLineColor:=0.1;
   gLineColor:=0.1;
   bLineColor:=0.1;
   aLineColor:=1.0;     //dark gray
   rNodeColor:=0.0;
   gNodeColor:=0.6;
   bNodeColor:=0.0;
   aNodeColor:=1.0;    //dark green
   rBackGroundColor:=0.8;
   gBackGroundColor:=0.8;
   bBackGroundColor:=0.8;
   aBackGroundColor:=1.0;     //bright gray
   rCoordColor:=0.0;
   gCoordColor:=0.6;
   bCoordColor:=0.0;
   aCoordColor:=1.0;      //dark green
   rIndexColor:=0.0;
   gIndexColor:=0.0;
   bIndexColor:=1.0;
   aIndexColor:=1.0;     //blue
   rSelectColor:=1.0;
   gSelectColor:=1.0;
   bSelectColor:=0.0;
   aSelectColor:=1.0;   //yellow
   rTractionColor:=0.0;
   gTractionColor:=0.0;
   bTractionColor:=0.8;
   aTractionColor:=1.0;    //blue
   rKinmatColor:=0.0;
   gKinmatColor:=1.0;
   bKinmatColor:=0.0;
   aKinmatColor:=1.0;   //green
   //Dimensions
     {MinX,MaxX,MinY,MaxY,xShift,yShift,XYClientRatio
      are not initialized here}
   MarginRatio:= 0.1;
   XYUnitScaleRatio:= 1;
   //variables related to menu
   mvCoordinated:= False;
   mvDiscarded:= True;
   mvShaped:= True;
   IndexSelect:= objNode;
   PlotLevel:= lvSubElement;
   //state variables related to draging
   mouseL:= False;
   //other
   CharSize:= 6;
   SetLength(XVertices, 6);
   SetLength(YVertices, 6);
   SetLength(Coners, 7);
end;{procedure FormCreate}

procedure TMainViewerForm.InitOpenGL;
{assumption: The related variables are initialized by FromCreate}
var
  pfd: TPixelFormatDescriptor;
  FormatIndex: integer;
begin
 //free the old context
  if OpenGLReady then begin
    wglMakeCurrent(glDC,0);
    wglDeleteContext(GLContext);
    OpenGLReady:= false;
  end;
 //the contexts
  fillchar(pfd, SizeOf(pfd),0);
  with pfd do
  begin
    nSize := sizeOf(pfd);
    nVersion := 1;
    dwFlags := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL;
    iPixelType := PFD_TYPE_RGBA;
    cColorBits := 24;
    cDepthBits := 32;
    iLayerType := PFD_MAIN_PLANE;
  end;{with}
  glDC:= getDC(MainViewerForm.Handle);
  FormatIndex := ChoosePixelFormat(glDC,@pfd);
  if not SetPixelFormat(glDC,FormatIndex, @pfd) then
    ShowMessage('MainViewer: test point 8');
  GLContext := wglCreateContext(glDC);
  if not wglMakeCurrent(glDC, GLContext) then
    ShowMessage('MainViewer: test point 7');
 //the character bitmaps
  CusFont:= TFont.Create;
  CusFont.Height:= CharSize;
  SelectObject(glDC, CusFont.Handle);
  finderr('MainViewer: test point 6');
  wglUseFontBitmaps(glDC, 32, 26, 33);
  glListBase(1);
  finderr('MainViewer: test point 5');
 //other
  glClearColor(rBackGroundColor, gBackGroundColor,
               bBackGroundColor, aBackGroundColor);
  glEnable(GL_DEPTH_TEST);
  finderr('MainViewer: test point 4');
  OpenGLReady:= True;
  finderr('MainViewer: test point 3');
end;{procedure InitOpenGL}






procedure TMainViewerForm.DrawUshapedM;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X, Y: Real; //temp variables for coordinates
begin
 //draw the wireframe
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(UBlockM) do begin
   //get the coordinates
    GetUBlockVertexCoordV(i,True,XVertices,YVertices);
   //Draw the lines
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //paint the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor); 
  if (IndexSelect=objNODE) then begin
    for i:= 1 to Length(UNodeM) do begin
      PaintNum(UNodeM[i-1].ShapedX+xShift,
               UNodeM[i-1].ShapedY+yShift,
               PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(UBlockM) do begin
      GetUBlockVertexCoordV(i,True,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNONE) then begin
         //do nothing
  end;{if IndexSelect}
 //paint the coordinates
 glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UNodeM) do begin
      X:= UNodeM[i-1].ShapedX;
      Y:= UNodeM[i-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;{if}
end;{procedure DrawUshapedM}






procedure TMainViewerForm.DrawUshapedE;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variables for coordinates
begin
 //draw the wireframe
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(UElementE) do begin
   //get the coordinates
    GetUElementVertexCoordV(i, True, XVertices, YVertices);
   //Draw the lines
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //paint the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:= 1 to Length(UNodeE) do begin
      PaintNum(UNodeS[UNodeE[i-1]-1].ShapedX+xShift,
               UNodeS[UNodeE[i-1]-1].ShapedY+yShift,
               PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(UElementE) do begin
      GetUElementVertexCoordV(i,True,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNONE) then begin
         //do nothing
  end;{if IndexSelect}
 //paint the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UElementE) do begin
      X:= UNodeS[UNodeE[i-1]-1].ShapedX;
      Y:= UNodeS[UNodeE[i-1]-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;{if}
end;{procedure DrawUshapedM}





procedure TMainViewerForm.DrawUshapedS;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(USubElementS) do begin
   //get the coordinates
    GetUSubElementVertexCoordV(i, True, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
      glVertex3f(XVertices[4], YVertices[4], 0);
      glVertex3f(XVertices[5], YVertices[5], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(UNodeS) do begin
      X:= UNodeS[i-1].ShapedX;
      Y:= UNodeS[i-1].ShapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(USubElementS) do begin
      if ((i)mod(2))=1 then begin
        X:= 0.5 * ( UNodeS[USubElementS[i-1].V2-1].ShapedX
                   +UNodeS[USubElementS[i-1].V5-1].ShapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[i-1].V2-1].ShapedY
                   +UNodeS[USubElementS[i-1].V5-1].ShapedY );
      end else begin
        X:= 0.5 * ( UNodeS[USubElementS[i-1].V3-1].ShapedX
                   +UNodeS[USubElementS[i-1].V6-1].ShapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[i-1].V3-1].ShapedY
                   +UNodeS[USubElementS[i-1].V6-1].ShapedY );
      end;{ if (i)mod(2) }
      PaintNum( X, Y, PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end;{if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UNodeS) do begin
      X:= UNodeS[i-1].ShapedX;
      Y:= UNodeS[i-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;
end;{procedure DrawUshapedS}






procedure TMainViewerForm.DrawDshapedM;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(DBlockM) do begin
   //get the coordinates
    GetDBlockVertexCoordV(i, True, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeM) do begin
      X:= UNodeM[DNodeM[i-1]-1].ShapedX;
      Y:= UNodeM[DNodeM[i-1]-1].ShapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DBlockM) do begin
      GetDBlockVertexCoordV(i,True,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end;{if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeM) do begin
      X:= UNodeM[DNodeM[i-1]-1].ShapedX;
      Y:= UNodeM[DNodeM[i-1]-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;
end; {procedure DrawDshapedM}





procedure TMainViewerForm.DrawDshapedE;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(DElementE) do begin
   //get the coordinates
    GetDElementVertexCoordV(i, True, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeE) do begin
      X:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].ShapedX;
      Y:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].ShapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DElementE) do begin
      GetDElementVertexCoordV(i,True,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end; {if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeE) do begin
      X:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].ShapedX;
      Y:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;
end; {procedure DrawDshapedE}





procedure TMainViewerForm.DrawDshapedS;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i,k,l: Integer;
  X,Y: Real; //temp variable for coordinates
begin
  l:= Length(DSubElementS);
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to l do begin
   //get the coordinates
    GetDSubElementVertexCoordV(i, True, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
      glVertex3f(XVertices[4], YVertices[4], 0);
      glVertex3f(XVertices[5], YVertices[5], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeS) do begin
      X:= UNodeS[DNodeS[i-1]-1].ShapedX;
      Y:= UNodeS[DNodeS[i-1]-1].ShapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DSubElementS) do begin
      k:= DSubElementS[i-1];
      if ((i)mod(2))=1 then begin
        X:= 0.5 * ( UNodeS[USubElementS[k-1].V2-1].ShapedX
                   +UNodeS[USubElementS[k-1].V5-1].ShapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[k-1].V2-1].ShapedY
                   +UNodeS[USubElementS[k-1].V5-1].ShapedY );
      end else begin
        X:= 0.5 * ( UNodeS[USubElementS[k-1].V3-1].ShapedX
                   +UNodeS[USubElementS[k-1].V6-1].ShapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[k-1].V3-1].ShapedY
                   +UNodeS[USubElementS[k-1].V6-1].ShapedY );
      end;{ if (i)mod(2) }
      PaintNum( X, Y, PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end;{if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeS) do begin
      X:= UNodeS[DNodeS[i-1]-1].ShapedX;
      Y:= UNodeS[DNodeS[i-1]-1].ShapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;                
end; {procedure DrawDshapedS}






procedure TMainViewerForm.DrawUunshapedM;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X, Y: Real; //temp variables for coordinates
begin
 //draw the wireframe
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(UBlockM) do begin
   //get the coordinates
    GetUBlockVertexCoordV(i,False,XVertices,YVertices);
   //Draw the lines
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //paint the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor); 
  if (IndexSelect=objNODE) then begin
    for i:= 1 to Length(UNodeM) do begin
      PaintNum(UNodeM[i-1].UnshapedX+xShift,
               UNodeM[i-1].UnshapedY+yShift,
               PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(UBlockM) do begin
      GetUBlockVertexCoordV(i,False,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNONE) then begin
         //do nothing
  end;{if IndexSelect}
 //paint the coordinates
 glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UNodeM) do begin
      X:= UNodeM[i-1].UnshapedX;
      Y:= UNodeM[i-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;{if}
end;{procedure}







procedure TMainViewerForm.DrawUunshapedE;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variables for coordinates
begin
 //draw the wireframe
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(UElementE) do begin
   //get the coordinates
    GetUElementVertexCoordV(i, False, XVertices, YVertices);
   //Draw the lines
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //paint the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:= 1 to Length(UNodeE) do begin
      PaintNum(UNodeS[UNodeE[i-1]-1].UnshapedX+xShift,
               UNodeS[UNodeE[i-1]-1].UnshapedY+yShift,
               PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(UElementE) do begin
      GetUElementVertexCoordV(i,False,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNONE) then begin
         //do nothing
  end;{if IndexSelect}
 //paint the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UNodeE) do begin
      X:= UNodeS[UNodeE[i-1]-1].UnshapedX;
      Y:= UNodeS[UNodeE[i-1]-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;{if}
end;{procedure DrawUunshapedE}






procedure TMainViewerForm.DrawUunshapedS;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(USubElementS) do begin
   //get the coordinates
    GetUSubElementVertexCoordV(i, False, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
      glVertex3f(XVertices[4], YVertices[4], 0);
      glVertex3f(XVertices[5], YVertices[5], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(UNodeS) do begin
      X:= UNodeS[i-1].UnshapedX;
      Y:= UNodeS[i-1].UnshapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(USubElementS) do begin
      if ((i)mod(2))=1 then begin
        X:= 0.5 * ( UNodeS[USubElementS[i-1].V2-1].UnshapedX
                   +UNodeS[USubElementS[i-1].V5-1].UnshapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[i-1].V2-1].UnshapedY
                   +UNodeS[USubElementS[i-1].V5-1].UnshapedY );
      end else begin
        X:= 0.5 * ( UNodeS[USubElementS[i-1].V3-1].UnshapedX
                   +UNodeS[USubElementS[i-1].V6-1].UnshapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[i-1].V3-1].UnshapedY
                   +UNodeS[USubElementS[i-1].V6-1].UnshapedY );
      end;{ if (i)mod(2) }
      PaintNum( X, Y, PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end; {if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(UNodeS) do begin
      X:= UNodeS[i-1].UnshapedX;
      Y:= UNodeS[i-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;
end;{procedure DrawUunshapedS}






procedure TMainViewerForm.DrawDunshapedM;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);

  for i:= 1 to Length(DBlockM) do begin
   //get the coordinates
    GetDBlockVertexCoordV(i, False, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeM) do begin
      X:= UNodeM[DNodeM[i-1]-1].UnshapedX;
      Y:= UNodeM[DNodeM[i-1]-1].UnshapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DBlockM) do begin
      GetDBlockVertexCoordV(i,False,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end; {if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeM) do begin
      X:= UNodeM[DNodeM[i-1]-1].UnshapedX;
      Y:= UNodeM[DNodeM[i-1]-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)', [X,Y])) );
    end;
  end;
end; {procedure DrawDunshapedM}





procedure TMainViewerForm.DrawDunshapedE;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(DElementE) do begin
   //get the coordinates
    GetDElementVertexCoordV(i, False, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeE) do begin
      X:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].UnshapedX;
      Y:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].UnshapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DElementE) do begin
      GetDElementVertexCoordV(i,False,XVertices,YVertices);
      GetPolygonConerTypeV( 4, XVertices, YVertices, Coners);
      if Coners[0]=0 then begin
        //valid OpenGL polygon
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[1]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else if Coners[2]=0 then begin
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end else if Coners[3]=0 then begin
        X:= 0.5*(XVertices[0]+XVertices[2]);
        Y:= 0.5*(YVertices[0]+YVertices[2]);
      end else begin
        //Coner[4]=0
        X:= 0.5*(XVertices[1]+XVertices[3]);
        Y:= 0.5*(YVertices[1]+YVertices[3]);
      end;{if Coners}
      PaintNum( X, Y,PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end; {if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeE) do begin
      X:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].UnshapedX;
      Y:= UNodeS[UNodeE[DNodeE[i-1]-1]-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;
end; {procedure DrawDunshapedE}







procedure TMainViewerForm.DrawDunshapedS;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var
  i,k: Integer;
  X,Y: Real; //temp variable for coordinates
begin
 //draw the wire frame
  glColor4f(rLineColor, gLineColor, bLineColor, aLineColor);
  for i:= 1 to Length(DSubElementS) do begin
   //get the coordinates
    GetDSubElementVertexCoordV(i, False, XVertices, YVertices);
   //draw the wire frame
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0);
      glVertex3f(XVertices[1], YVertices[1], 0);
      glVertex3f(XVertices[2], YVertices[2], 0);
      glVertex3f(XVertices[3], YVertices[3], 0);
      glVertex3f(XVertices[4], YVertices[4], 0);
      glVertex3f(XVertices[5], YVertices[5], 0);
    glEnd;
  end;
 //print the indices
  glColor4f(rIndexColor, gIndexColor, bIndexColor, aIndexColor);
  if (IndexSelect=objNODE) then begin
    for i:=1 to Length(DNodeS) do begin
      X:= UNodeS[DNodeS[i-1]-1].UnshapedX;
      Y:= UNodeS[DNodeS[i-1]-1].UnshapedY;
      PaintNum(X+xShift, Y+yShift, PChar(IntToStr(i)) );
    end;
  end else if (IndexSelect=objPIECE) then begin
    for i:= 1 to Length(DSubElementS) do begin
      k:= DSubElementS[i-1];
      if ((i)mod(2))=1 then begin
        X:= 0.5 * ( UNodeS[USubElementS[k-1].V2-1].UnshapedX
                   +UNodeS[USubElementS[k-1].V5-1].UnshapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[k-1].V2-1].UnshapedY
                   +UNodeS[USubElementS[k-1].V5-1].UnshapedY );
      end else begin
        X:= 0.5 * ( UNodeS[USubElementS[k-1].V3-1].UnshapedX
                   +UNodeS[USubElementS[k-1].V6-1].UnshapedX );
        Y:= 0.5 * ( UNodeS[USubElementS[k-1].V3-1].UnshapedY
                   +UNodeS[USubElementS[k-1].V6-1].UnshapedY );
      end;{ if (i)mod(2) }
      PaintNum( X, Y, PChar(IntToStr(i)) );
    end; {for 1 to number of pieces}
  end else if (IndexSelect=objNone) then begin
        //do nothing
  end; {if IndexSelect}
 //print the coordinates
  glColor4f(rCoordColor, gCoordColor, bCoordColor, aCoordColor);
  if mvCoordinated then begin
    for i:= 1 to Length(DNodeS) do begin
      X:= UNodeS[DNodeS[i-1]-1].UnshapedX;
      Y:= UNodeS[DNodeS[i-1]-1].UnshapedY;
      PaintNum(X+0.3*xShift, Y-5*yShift, PChar(Format('(%f, %f)',[X,Y])) );
    end;
  end;
end; 







procedure TMainViewerForm.DrawHighLightBlock;
{assumption: 1) this function is only called by MainViewerForm.DrawScene
             2) MainControlForm.StructureLoaded
             3) buffer cleared, modelview transformation doned
             4) projection view done somewhere else}
var avail: Boolean;
begin
  avail:= (UBlockM[SelectedBlockIndex-1].mtlIndex in [1..NumMaterials]);
  if avail or (not mvDiscarded) then begin
    GetUBlockVertexCoordV(SelectedBlockIndex, mvShaped, XVertices, YVertices);
    glColor4f(rSelectColor, gSelectColor, bSelectColor, aSelectColor);
    glBegin(GL_LINE_LOOP);
      glVertex3f(XVertices[0], YVertices[0], 0.2);
      glVertex3f(XVertices[1], YVertices[1], 0.2);
      glVertex3f(XVertices[2], YVertices[2], 0.2);
      glVertex3f(XVertices[3], YVertices[3], 0.2);
    glEnd;
  end;{if}
end;{procedure DrawHighLightBlock}





procedure TMainViewerForm.DrawTractionBoundary;
var i,j,l,lM: Integer;
begin
  glColor4f(rTractionColor, gTractionColor,
            bTractionColor, aTractionColor);
  glLineWidth(5);
  l:= length(TractionBoundary);
  if mvShaped then begin
    for i:= 0 to (l-1) do begin
      lM:= length(TractionBoundary[i].MSequence)-1;
        for j:= 0 to (lM-1) do begin
        glBegin(GL_LINES);
          glVertex3f(UNodeM[TractionBoundary[i].MSequence[j]-1].ShapedX,
                     UNodeM[TractionBoundary[i].MSequence[j]-1].ShapedY,
                     0.1);
          glVertex3f(UNodeM[TractionBoundary[i].MSequence[j+1]-1].ShapedX,
                     UNodeM[TractionBoundary[i].MSequence[j+1]-1].ShapedY,
                     0.1);
        glEnd;
      end;
    end;{for i}
  end else begin
    for i:= 0 to (l-1) do begin
      lM:= length(TractionBoundary[i].MSequence)-1;
        for j:= 0 to (lM-1) do begin
        glBegin(GL_LINES);
          glVertex3f(UNodeM[TractionBoundary[i].MSequence[j]-1].UnshapedX,
                     UNodeM[TractionBoundary[i].MSequence[j]-1].UnshapedY,
                     0.1);
          glVertex3f(UNodeM[TractionBoundary[i].MSequence[j+1]-1].UnshapedX,
                     UNodeM[TractionBoundary[i].MSequence[j+1]-1].UnshapedY,
                     0.1);
        glEnd;
      end;
    end;{for i}
  end;{if mvShaped}
  glLineWidth(1);
end;{procedure DrawTractionBoundary}

procedure TMainViewerForm.DrawKinmatBoundary;
var i,j,l,lM: Integer;
begin
  glColor4f(rKinmatColor, gKinmatColor,
            bKinmatColor, aKinmatColor);
  glLineWidth(5);
  l:= length(KinmatBoundary);
  if mvShaped then begin
    for i:= 0 to (l-1) do begin
      lM:= length(KinmatBoundary[i].MSequence)-1;
        for j:= 0 to (lM-1) do begin
        glBegin(GL_LINES);
          glVertex3f(UNodeM[KinmatBoundary[i].MSequence[j]-1].ShapedX,
                     UNodeM[KinmatBoundary[i].MSequence[j]-1].ShapedY,
                     0.1);
          glVertex3f(UNodeM[KinmatBoundary[i].MSequence[j+1]-1].ShapedX,
                     UNodeM[KinmatBoundary[i].MSequence[j+1]-1].ShapedY,
                     0.1);
        glEnd;
      end;
    end;{for i}
  end else begin
    for i:= 0 to (l-1) do begin
      lM:= length(KinmatBoundary[i].MSequence)-1;
        for j:= 0 to (lM-1) do begin
        glBegin(GL_LINES);
          glVertex3f(UNodeM[KinmatBoundary[i].MSequence[j]-1].UnshapedX,
                     UNodeM[KinmatBoundary[i].MSequence[j]-1].UnshapedY,
                     0.1);
          glVertex3f(UNodeM[KinmatBoundary[i].MSequence[j+1]-1].UnshapedX,
                     UNodeM[KinmatBoundary[i].MSequence[j+1]-1].UnshapedY,
                     0.1);
        glEnd;
      end;
    end;{for i}
  end;{if mvShaped}
  glLineWidth(1);
end;{procedure DrawKinmatBoundary}

procedure TMainViewerForm.DrawScene;
{assumption: OpenGL is initialized}
begin
 //initialize the OpenGL for MainViewer
  MainViewerForm.InitOpenGL;
  finderr('test point 2');
 //set the render mode for drawing
  glRenderMode(GL_RENDER);
 //clear the buffer
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
 //Model-View transformation
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  gluLookAt(0,0,1, 0,0,0, 0,1,0);
 //Projection transformation
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  glOrtho(LeftDisplayEdge, RightDisplayEdge,
          LowDisplayEdge, HighDisplayEdge,
          0, 2);            
 ////draw differently according to M/E/S level
 //Discard/Undiscard and Shaped/Unshaped
  if (PlotLevel=lvMASTER)and(mvShaped)and(mvDiscarded) then begin
    DrawDshapedM;
  end else if (PlotLevel=lvELEMENT)and(mvShaped)and(mvDiscarded) then begin
    DrawDshapedE;
  end else if (PlotLevel=lvSUBELEMENT)and(mvShaped)and(mvDiscarded) then begin
    DrawDshapedS;
  end else if (PlotLevel=lvMASTER)and(not mvShaped)and(mvDiscarded) then begin
    DrawDunshapedM;
  end else if (PlotLevel=lvELEMENT)and(not mvShaped)and(mvDiscarded) then begin
    DrawDunshapedE;
  end else if (PlotLevel=lvSUBELEMENT)and(not mvShaped)and(mvDiscarded) then begin
    DrawDunshapedS;
  end else if (PlotLevel=lvMASTER)and(mvShaped)and(not mvDiscarded) then begin
    DrawUshapedM;
  end else if (PlotLevel=lvELEMENT)and(mvShaped)and(not mvDiscarded) then begin
    DrawUshapedE;
  end else if (PlotLevel=lvSUBELEMENT)and(mvShaped)and(not mvDiscarded) then begin
    DrawUshapedS;
  end else if (PlotLevel=lvMASTER)and(not mvShaped)and(not mvDiscarded) then begin
    DrawUunshapedM;
  end else if (PlotLevel=lvELEMENT)and(not mvShaped)and(not mvDiscarded) then begin
    DrawUunshapedE;
  end else if (PlotLevel=lvSUBELEMENT)and(not mvShaped)and(not mvDiscarded) then begin
    DrawUunshapedS;
  end;
 //highlight the selected block
  DrawHighLightBlock;
 //draw the boundaries
  if mvDiscarded then begin
    DrawTractionBoundary;
    DrawKinmatBoundary;
  end;
 //flush
  glFlush;
  finderr('main viewer test point 1');
end;{procedure DrawScene}

procedure TMainViewerForm.SetCriticalValues;
{assumption: 1) there is a structure loaded
 post:1) set up these variables for being keep until structure changed:
         MinX, MaxX, MinY, MaxY, XYClientRatio, xShift, yShift,
         SceneWidth, SceneHeight
      2) initialize up these variables for being modified when drag/zoom:
         LeftDisplayEdge, RightDisplayEdge, LowDisplayEdge,
         HighDisplayEdge   }
var
  i, n: Integer;
begin
 //get the number of master undiscarded nodes
  n:= Length(UNodeM);
 //initialize MinX, MaxX, MinY, MaxY
  MinX:=0;
  MaxX:=XLinearIndex[NumCol].Distance;
  MinY:=0;
  MaxY:=YLinearIndex[NumRow].Distance;
 //get MinX, MaxX, MinY, MaxY
  for i:= 1 to n do begin
    if UNodeM[i-1].ShapedX>MaxX then MaxX:=UNodeM[i-1].ShapedX;
    if UNodeM[i-1].ShapedX<MinX then MinX:=UNodeM[i-1].ShapedX;
    if UNodeM[i-1].ShapedY>MaxY then MaxY:=UNodeM[i-1].ShapedY;
    if UNodeM[i-1].ShapedY<MinY then MinY:=UNodeM[i-1].ShapedY;
  end;
 //get StructureWidth, StructureHeight, XYClientRatio
  StructureWidth:= MaxX-MinX;
  StructureHeight:= MaxY-MinY;
  XYClientRatio:= XYUnitScaleRatio*(StructureWidth/StructureHeight);
 //get xShift, yShift
  xShift:= (0.15*StructureWidth)/XLinearIndex[NumCol].SIndex;
  yShift:= (0.05*StructureHeight)/YLinearIndex[NumRow].SIndex;
 //initialize the display edges and display ranges
  LeftDisplayEdge:=MinX-MarginRatio*StructureWidth;
  RightDisplayEdge:=MaxX+2*MarginRatio*StructureWidth;
  LowDisplayEdge:=MinY-MarginRatio*StructureHeight;
  HighDisplayEdge:=MaxY+MarginRatio*StructureHeight;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;
end;{procedure SetCriticalValues}


procedure TMainViewerForm.FormResize(Sender: TObject);
begin
  if (MainControlForm.StructureLoaded) then begin
   //decide the dimension of MainViewer
    ClientWidth:= ceil(ClientHeight*XYClientRatio); 
   //redefine the view port
    glViewPort(0, 0, ClientWidth, ClientHeight);
   //if ClientHeight<OldClientHeight, OnPaint will not be trigerred 
    if ClientHeight<OldClientHeight then DrawScene;
  end;
  OldClientHeight:= ClientHeight;
  OldClientWidth:= ClientWidth;
end;

procedure TMainViewerForm.MasterMenuItemLV2Click(Sender: TObject);
begin
  MasterMenuItemLV2.Checked:= True;
  ElementMenuItemLV2.Checked:= False;
  SubElementMenuItemLV2.Checked:= False;
  PlotLevel:= lvMaster;
  DrawScene;
end;

procedure TMainViewerForm.ElementMenuItemLV2Click(Sender: TObject);
begin
  MasterMenuItemLV2.Checked:= False;
  ElementMenuItemLV2.Checked:= True;
  SubElementMenuItemLV2.Checked:= False;
  PlotLevel:= lvElement;
  DrawScene;
end;

procedure TMainViewerForm.SubElementMenuItemLV2Click(Sender: TObject);
begin
  MasterMenuItemLV2.Checked:= False;
  ElementMenuItemLV2.Checked:= False;
  SubElementMenuItemLV2.Checked:= True;
  PlotLevel:= lvSubElement;
  DrawScene;
end;

procedure TMainViewerForm.ShapedMenuItemClick(Sender: TObject);
begin
  ShapedMenuItem.Checked:= (not (ShapedMenuItem.Checked));
  mvShaped:= ShapedMenuItem.Checked;
  DrawScene;
end; 

procedure TMainViewerForm.DiscardMenuItemClick(Sender: TObject);
begin
  DiscardMenuItem.Checked:= (not (DiscardMenuItem.Checked));
  mvDiscarded:= DiscardMenuItem.Checked;
  DrawScene;
end;

procedure TMainViewerForm.CoordinateMenuItemClick(Sender: TObject);
begin
  CoordinateMenuItem.Checked:= (not (CoordinateMenuItem.Checked));
  mvCoordinated:= CoordinateMenuItem.Checked;
  DrawScene;
end;

procedure TMainViewerForm.NoneMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= True;
  NodeMenuItemLV2.Checked:= False;
  PieceMenuItemLV2.Checked:= False;
  IndexSelect:= objNONE;
  DrawScene;
end;

procedure TMainViewerForm.NodeMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= False;
  NodeMenuItemLV2.Checked:= True;
  PieceMenuItemLV2.Checked:= False;
  IndexSelect:= objNODE;
  DrawScene;
end;

procedure TMainViewerForm.PieceMenuItemLV2Click(Sender: TObject);
begin
  NoneMenuItemLV2.Checked:= False;
  NodeMenuItemLV2.Checked:= False;
  PieceMenuItemLV2.Checked:= True;
  IndexSelect:= objPIECE;
  DrawScene;
end;

procedure TMainViewerForm.FormPaint(Sender: TObject);
begin
  if MainControlForm.StructureLoaded then DrawScene;
end;

procedure TMainViewerForm.ZoomInMenuItemClick(Sender: TObject);
var CX,CY: Real;
begin
  CX:= 0.5*(LeftDisplayEdge+RightDisplayEdge);
  CY:= 0.5*(LowDisplayEdge+HighDisplayEdge);
  LeftDisplayEdge:= CX-0.8*0.5*XDisplayRange;
  RightDisplayEdge:= CX+0.8*0.5*XDisplayRange;
  LowDisplayEdge:= CY-0.8*0.5*YDisplayRange;
  HighDisplayEdge:= CY+0.8*0.5*YDisplayRange;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;
  DrawScene;
end;

procedure TMainViewerForm.ZoomOutMenuItemClick(Sender: TObject);
var CX,CY: Real;
begin
  CX:= 0.5*(LeftDisplayEdge+RightDisplayEdge);
  CY:= 0.5*(LowDisplayEdge+HighDisplayEdge);
  LeftDisplayEdge:= CX-1.25*0.5*XDisplayRange;
  RightDisplayEdge:= CX+1.25*0.5*XDisplayRange;
  LowDisplayEdge:= CY-1.25*0.5*YDisplayRange;
  HighDisplayEdge:= CY+1.25*0.5*YDisplayRange;
  XDisplayRange:= RightDisplayEdge-LeftDisplayEdge;
  YDisplayRange:= HighDisplayEdge-LowDisplayEdge;
  DrawScene;
end;

procedure TMainViewerForm.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbLeft then begin
   //this variable is kept only for flexibility
    mouseL:= True;
   //back up the state for redrawing
    tailX:= X;
    tailY:= Y;
    OldLeftDisplayEdge:= LeftDisplayEdge;
    OldRightDisplayEdge:=RightDisplayEdge;
    OldLowDisplayEdge:=LowDisplayEdge;
    OldHighDisplayEdge:=HighDisplayEdge;
  end;
end;

procedure TMainViewerForm.FormMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var defX,defY: real;
begin
  if MainControlForm.StructureLoaded then begin
   //redraw the scene
    defX:= XDisplayRange*(X-tailX)/ClientWidth;
    defY:= YDisplayRange*(tailY-Y)/ClientHeight;
    LeftDisplayEdge:=OldLeftDisplayEdge-defX;
    RightDisplayEdge:=OldRightDisplayEdge-defX;
    LowDisplayEdge:=OldLowDisplayEdge-defY;
    HighDisplayEdge:=OldHighDisplayEdge-defY;
    DrawScene;
   end;{if StructureLoaded}
 //no effect but kept for flexibility
  mouseL:=False;
end;

procedure TMainViewerForm.UnZoomMenuItemClick(Sender: TObject);
begin
  MainViewerForm.ReloadMenuItemClick(nil);
end;

procedure TMainViewerForm.FormDestroy(Sender: TObject);
begin
  if OpenGLReady then begin
    wglMakeCurrent(glDC,0);
    wglDeleteContext(GLContext);
    OpenGLReady:= false
  end;
end;

procedure TMainViewerForm.ChangeXYUnitScaleRatioClick(Sender: TObject);
var
  tmpString: string;
begin
  tmpString:='Not A Positive Number';
  while not StrCanToPosF(tmpString) do begin
    tmpString:= InputBox('XYUnitScaleRatio Editor',
                         'New XYUnitScaleRatio: ',
                         FloatToStr(XYUnitScaleRatio));
  end;
  XYUnitScaleRatio:= StrToFloat(tmpString);
  MainViewerForm.ReloadMenuItemClick(nil);
end;{procedure ChangeXYUnitScaleRatioClick}

end.
