unit MainControl;

interface

uses
 //Delphi provided units
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, AxCtrls, OleCtrls, vcf1, StdCtrls,
  ShellApi, ToolWin, ComCtrls, OpenGL,
 //GUI units
  GridBlockViewer, NodeViewer, MaterialViewer, MainViewer,
  PieceViewer, LinearDivisionViewer, StructureInitializer,
  BoundaryViewer, BlockInfoViewer, AnalyzeResultViewer,
 //data structure unit
  ConvLib, AnalyzeLib, ExtCtrls;
type
  TMainControlForm = class(TForm)
    MainControlMenu: TMainMenu;
    FileMenu: TMenuItem;
    NewMenuItem: TMenuItem;
    OpenMenuItem: TMenuItem;
    ExitMenuItem: TMenuItem;
    EditMenu: TMenuItem;
    SaveAsMenuItem: TMenuItem;
    SaveMenuItem: TMenuItem;
    SettoDefault1: TMenuItem;
    FixallNodes1: TMenuItem;
    UnFixallNodes1: TMenuItem;
    FixallNodesY1: TMenuItem;
    UnFixallNodesY1: TMenuItem;
    HelpMenu: TMenuItem;
    StructureEditorHelpMenuItem: TMenuItem;
    AboutStructureEditorMenuItem: TMenuItem;
    ImportMenuItem: TMenuItem;
    OpenDialog: TOpenDialog;
    ToolsMenu: TMenuItem;
    LinearDivisionViewerMenuItem: TMenuItem;
    BlockViewerMenuItem: TMenuItem;
    MainViewerMenuItem: TMenuItem;
    NodeViewerMenuItem: TMenuItem;
    PieceViewerMenuItem: TMenuItem;
    BoundaryViewerMenuItem: TMenuItem;
    MaterialViewerMenuItem: TMenuItem;
    MessageLabel: TLabel;
    AnalyzeMenu: TMenuItem;
    AnalyzeModeMenuItem: TMenuItem;
    RunAnalyzeMenuItem: TMenuItem;
    N1: TMenuItem;
    EnergyMenuItemLV2: TMenuItem;
    PressureMenuItemLV2: TMenuItem;
    procedure NewMenuItemClick(Sender: TObject);
    procedure LinearDivisionViewerMenuItemClick(Sender: TObject);
    procedure OpenMenuItemClick(Sender: TObject);
    procedure SaveMenuItemClick(Sender: TObject);
    procedure SaveAsMenuItemClick(Sender: TObject);
    procedure ExitMenuItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure NodeViewerMenuItemClick(Sender: TObject);
    procedure MaterialViewerMenuItemClick(Sender: TObject);
    procedure MainViewerMenuItemClick(Sender: TObject);
    procedure BlockViewerMenuItemClick(Sender: TObject);
    procedure BoundaryViewerMenuItemClick(Sender: TObject);
    procedure PieceViewerMenuItemClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure AnalyzeModeMenuItemClick(Sender: TObject);
    procedure PressureMenuItemLV2Click(Sender: TObject);
    procedure EnergyMenuItemLV2Click(Sender: TObject);
    procedure AboutStructureEditorMenuItemClick(Sender: TObject);
    procedure StructureEditorHelpMenuItemClick(Sender: TObject);
  private
    { Private declarations }
    procedure MakeColorMap;
  public
    { Public declarations }
    StructureLoaded, StructureSaved: Boolean;
    ProjectPathName: string;
    procedure SetAllEnabledValues(TruthValue: Boolean);
    procedure InitDefaultVisibility;
    procedure ApplyVisibility;
    procedure GetVisibility;
    procedure ReloadAll(Sender: TObject);
    procedure ForceToModifyBoundary;
    procedure GoModifyingMode;
    procedure LeaveModifyingMode;
  end;

type
  TColorMapElement=record
    red, green, blue, alpha: GLubyte;
  end;

var
 //OpenGL context
  glDC: HDC;
  GLContext: HGLRC;
  OpenGLReady: Boolean;
 //variables to control visible/invisible
  MainControlForm: TMainControlForm;
  MainViewerVisible, BlockViewerVisible,
  LinearDivisionViewerVisible, NodeViewerVisible,
  PieceViewerVisible, BoundaryViewerVisible,
  MaterialViewerVisible :                     Boolean;
 //overall state of the program
  SelectedBlockIndex: Integer;
  ModifyingMode: Boolean;
  ForcedBoundaryModify: Boolean;
  AnalyzingMode: Boolean;
 //file system variable
  StructureEditorPath: string;
 //for value-color-mapping of Multiple-function-variable
  MultiFcnValColorMap: array of TColorMapElement;
 //for timeing purpose
  timeCounter: Integer;
implementation

{$R *.DFM}

procedure TMainControlForm.MakeColorMap;
var i: integer;
begin
  SetLength(MultiFcnValColorMap, 256);
  for i:= 0 to 127 do begin
    MultiFcnValColorMap[i].red:= 2*i;
    MultiFcnValColorMap[i].green:=255;
    MultiFcnValColorMap[i].blue:= 0;
    MultiFcnValColorMap[i].alpha:=255;
  end;{for first half of ColorMap}
  for i:= 128 to 255 do begin
    MultiFcnValColorMap[i].red:= 255;
    MultiFcnValColorMap[i].green:= (255-i)*2;
    MultiFcnValColorMap[i].blue:=0;
    MultiFcnValColorMap[i].alpha:=255;
  end;{for second half of ColorMap}
end;{procedure MakeColorMap}

procedure TMainControlForm.ApplyVisibility;
begin
  MainViewerForm.Visible:= MainViewerVisible;
  MainControlForm.MainViewerMenuItem.Checked
           := MainViewerVisible;
  GridBlockViewerForm.Visible:= BlockViewerVisible;
  MainControlForm.BlockViewerMenuItem.Checked
           :=BlockViewerVisible;
  LinearDivisionViewerForm.Visible:= LinearDivisionViewerVisible;
  MainControlForm.LinearDivisionViewerMenuItem.Checked
           := LinearDivisionViewerVisible;
  NodeViewerForm.Visible := NodeViewerVisible;
  MainControlForm.NodeViewerMenuItem.Checked
           := NodeViewerVisible;
  PieceViewerForm.Visible := PieceViewerVisible;
  MainControlForm.PieceViewerMenuItem.Checked
           := PieceViewerVisible;
  BoundaryViewerForm.Visible := BoundaryViewerVisible;
  MainControlForm.BoundaryViewerMenuItem.Checked
           := BoundaryViewerVisible;
  MaterialViewerForm.Visible:= MaterialViewerVisible;
  MainControlForm.MaterialViewerMenuItem.Checked
           := MaterialViewerVisible;
end; {procedure ApplyVisibility}

procedure TMainControlForm.GetVisibility;
begin
  MainViewerVisible:= MainViewerForm.Visible;
  BlockViewerVisible:= GridBlockViewerForm.Visible;
  LineardivisionViewerVisible := LinearDivisionViewerForm.Visible;
  NodeViewerVisible := NodeViewerForm.Visible;
  PieceViewerVisible := PieceViewerForm.Visible;
  BoundaryViewerVisible := BoundaryViewerform.Visible;
  MaterialViewerVisible := MaterialViewerForm.visible;
end; {procedure GetVisibility}

procedure TMainControlForm.ReloadAll(Sender: TObject);
begin
  if Sender<>MainViewerForm then
         MainViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>NodeViewerForm then
         NodeViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>PieceViewerForm then
         PieceViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>GridBlockViewerForm then
         GridBlockViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>MaterialViewerForm then
         MaterialViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>LinearDivisionViewerForm then
         LinearDivisionViewerForm.ReloadMenuItemClick(Sender);
  if Sender<>BoundaryViewerForm then
         BoundaryViewerForm.ReloadMenuItemClick(Sender);
end;

procedure TMainControlForm.ForceToModifyBoundary;
begin
 //make BoundaryViewer visible
  BoundaryViewerVisible:= True;
  MainControlForm.BoundaryViewerMenuItem.Checked:= True;
  BoundaryViewerForm.Visible:= True;
 //change state
  ForcedBoundaryModify:= True;
  BoundaryViewerForm.ModifyButtonClick(nil);
end;

procedure TMainControlForm.GoModifyingMode;
begin
  ModifyingMode:= True;
  MainControlForm.FileMenu.Enabled:= False;
  MainControlForm.EditMenu.Enabled:= False;
  MainControlForm.AnalyzeMenu.Enabled:= False;
end;

procedure TMainControlForm.LeaveModifyingMode;
begin
  ModifyingMode:= False;
  MainControlForm.FileMenu.Enabled:= True;
  MainControlForm.EditMenu.Enabled:= True;
  MainControlForm.AnalyzeMenu.Enabled:= True;
end;

procedure TMainControlForm.InitDefaultVisibility;
{assumption: called before the first time using
             boolean variables xxxxViewerVisible  }
begin
  MainViewerVisible:= True;
  BlockViewerVisible:= True;
  LinearDivisionViewerVisible:= False;
  NodeViewerVisible:= False;
  PieceViewerVisible:= False;
  BoundaryViewerVisible:= False;
  MaterialViewerVisible:= False;            
end;{procedure Initialize}

procedure TMainControlForm.NewMenuItemClick(Sender: TObject);
begin
  MainControlForm.SetAllEnabledValues(False);
  StructureInitializerForm.Enabled:=True;
  StructureInitializerForm.Visible:=True;
  StructureInitializerForm.BuildNewStructure;
end;

procedure TMainControlForm.SetAllEnabledValues(TruthValue: Boolean);
begin
 //MainControlForm is more complicated in logic
  MainControlForm.Enabled:=TruthValue;
  MainControlForm.FileMenu.Enabled:=TruthValue;
  MainControlForm.EditMenu.Enabled:=TruthValue;
 //other forms
  GridBlockViewerForm.Enabled:=TruthValue;
  BlockInfoViewerForm.Enabled:=TruthValue;
  NodeViewerForm.Enabled:=TruthValue;
  MaterialViewerForm.Enabled:=TruthValue;
  MainViewerForm.Enabled:=TruthValue;
  PieceViewerForm.Enabled:=TruthValue;
  LinearDivisionViewerForm.Enabled:=TruthValue;
  StructureInitializerForm.Enabled:=TruthValue;
end;{procedure SetAllEnabled}

procedure TMainControlForm.LinearDivisionViewerMenuItemClick(
  Sender: TObject);
begin
  LinearDivisionViewerVisible := (not LinearDivisionViewerVisible);
  MainControlForm.LinearDivisionViewerMenuItem.Checked:=
      LinearDivisionViewerVisible;
  LinearDivisionViewerForm.Visible:= LinearDivisionViewerVisible;
end;{Procedure}

procedure TMainControlForm.OpenMenuItemClick(Sender: TObject);
var
  tmpPathName: string;
  tmpMainViewerVisibility: boolean;
begin
   //make main viewer invisible
    tmpMainViewerVisibility := MainViewerForm.Visible;
    MainViewerForm.Visible := False;
with MainControlForm do begin
  if OpenDialog.Execute=True then begin
   //load the project to memory
    tmpPathName:=Copy(OpenDialog.FileName, 1, Length(OpenDialog.Filename)-4);
    LoadProject(tmpPathName);
   //modify the related variables
    ProjectPathName:= tmpPathName;
    StructureLoaded:= True;
    StructureSaved:= True;
    SelectedBlockIndex:= 1;
   //modify the GUI
    AnalyzeMenu.Enabled:= True;
   //set the message display
    MainControlForm.Caption:= 'StructureEditor--'+ProjectPathName;
   //ReloadAll must be called after StructureLoaded modified
    ReloadAll(MainControlForm);
  end;{if OpenDialog}
end;{with}
   //restore the visibility of MainViewerForm
    MainViewerForm.Visible := tmpMainViewerVisibility;
end;{procedure}

procedure TMainControlForm.SaveMenuItemClick(Sender: TObject);
begin
  MainControlForm.SetAllEnabledValues(False);
  SaveProject(ProjectPathName);
  MainControlForm.StructureSaved:= True;
  MainControlForm.SetAllEnabledValues(True);
end;

procedure TMainControlForm.SaveAsMenuItemClick(Sender: TObject);
var tmpPathName: string;
begin
MainControlForm.SetAllEnabledValues(False);
with MainControlForm do begin
  if OpenDialog.Execute then begin
    tmpPathName:=Copy(OpenDialog.FileName, 1,
                      Length(OpenDialog.Filename)-4 );
    SaveProject(tmpPathName);
    StructureSaved:= True;
    LoadProject(tmpPathName);
    ProjectPathName:= tmpPathName;
    StructureLoaded:= True;
  end else begin
   //nothing happen
  end;{ if OpenDialog.Execute}
end;{with}
MainControlForm.SetAllEnabledValues(True);
end;{procedure SaveAs}

procedure TMainControlForm.ExitMenuItemClick(Sender: TObject);
begin
  MainControlForm.Close;
end;{procedure}

procedure TMainControlForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  MessageReturnValue: word;
begin
  if    (MainControlForm.StructureSaved
         or (not MainControlForm.StructureLoaded))
     and (not ModifyingMode) then begin
    Action:= caFree;
  end else if ModifyingMode then begin
    ShowMessage('Sorry, modification must be '
               +'finished before closing');
    Action:= caNone;
  end else begin
    MessageReturnValue
        := MessageDlg('Do you want to save the project?',
                      mtConfirmation, [mbYes, mbNo, mbCancel],
                      0);
    case MessageReturnValue of
    mrYes: begin
        SaveProject(ProjectPathName);
        Action:= caFree;
        end;{mrYes}
    mrNo: Action:= caFree;
    mrCancel: Action:= caNone;
    else Action:= caNone; //impossible
    end;{case MessageReturnValue}
  end;{if StructureSaved}
end;{procedure}

procedure TMainControlForm.NodeViewerMenuItemClick(Sender: TObject);
begin
  NodeViewerVisible:=(not NodeViewerVisible);
  MainControlForm.NodeViewerMenuItem.Checked:= NodeViewerVisible;
  NodeViewerForm.Visible:= NodeViewerVisible;
end;{procedure}

procedure TMainControlForm.MaterialViewerMenuItemClick(Sender: TObject);
begin
  MaterialViewerVisible:= not MaterialViewerVisible;
  MainControlForm.MaterialViewerMenuItem.Checked:=
      MaterialViewerVisible;
  MaterialViewerForm.Visible:= MaterialViewerVisible;
end;

procedure TMainControlForm.MainViewerMenuItemClick(Sender: TObject);
begin
  MainViewerVisible:= not MainViewerVisible;
  MainControlForm.MainViewerMenuItem.Checked:= MainViewerVisible;
  MainViewerForm.Visible:= MainViewerVisible;
end;

procedure TMainControlForm.BlockViewerMenuItemClick(Sender: TObject);
begin
  BlockViewerVisible:= not BlockViewerVisible;
  MainControlForm.BlockViewerMenuItem.Checked:=
      BlockViewerVisible;
  GridBlockViewerForm.Visible:= BlockViewerVisible;
 //set the visibility of BlockInfoViewerForm (a slave of Block Viewer)
  if BlockViewerVisible then begin
    BlockInfoViewerForm.Visible:=
        GridBlockViewerForm.ShowBlockInfoMenuItem.Checked;
  end else begin
    BlockInfoViewerForm.Visible:= False;
  end;{if BlockViewerVisible}
end;

procedure TMainControlForm.BoundaryViewerMenuItemClick(Sender: TObject);
begin
  BoundaryViewerVisible:= not BoundaryViewerVisible;
  MainControlForm.BoundaryViewerMenuItem.Checked:=
      BoundaryViewerVisible;
  BoundaryViewerForm.Visible:= BoundaryViewerVisible;
end;

procedure TMainControlForm.PieceViewerMenuItemClick(Sender: TObject);
begin
  PieceViewerVisible:= not PieceViewerVisible;
  MainControlForm.PieceViewerMenuItem.Checked:= PieceViewerVisible;
  PieceViewerForm.Visible:= PieceViewerVisible;
end;

procedure TMainControlForm.FormCreate(Sender: TObject);
begin
 //init some GUI state variables
  SelectedBlockIndex:= 0;
  ModifyingMode:= False;
  ForcedBoundaryModify:= False;
  OpenGLReady:= False;
  StructureEditorPath:= GetCurrentDir;
  AnalyzingMode:= False;
 //set the multi-function-variable color map
  MakeColorMap;
end;

procedure TMainControlForm.FormResize(Sender: TObject);
begin
  MainControlForm.Height:= 70;
end;

procedure TMainControlForm.AnalyzeModeMenuItemClick(Sender: TObject);
var
  F: TextFile;
  FormatString: string;
begin
  if AnalyzingMode then begin
    {go back to viewing mode}
    //delete the temperary files

    //change the GUI (leave the analyzing mode)
     AnalyzingMode:= False;
     AnalyzeModeMenuItem.Checked:= False;
     RunAnalyzeMenuItem.Enabled:= False;
     FileMenu.Enabled:= True;
     EditMenu.Enabled:= True;
     AnalyzeResultViewerForm.Visible:= false;
  end else if not AnalyzingMode then begin
    {go into analyzing mode}
    //change the GUI
     FileMenu.Enabled:= False;
     EditMenu.Enabled:= False;
     AnalyzingMode:= True;
     AnalyzeModeMenuItem.Checked:= True;
     RunAnalyzeMenuItem.Enabled:= True;
    //generate the temperary files
     ielBuild(StructureEditorPath+'\in\data.iel');
     nndBuild(StructureEditorPath+'\in\data.nnd');
     mtlBuild(StructureEditorPath+'\in\data.mt0');
     trcBuild(StructureEditorPath+'\in\data.tr0');
    //set the in.txt file
     AssignFile(F, StructureEditorPath+'\Analyze\in.txt');
     rewrite(F);
     FormatString:=
       format('%d %d %d %d %d %d',
              [length(DNodeS){number of nodes},
               length(DSubElementS){number of elements},
               2{number of values per node},
               6{number of nodes per element},
               0{number of boundary elements},
               NumMaterials{number of materials} ]);
     writeln(F, FormatString);
     writeln(F, StructureEditorPath+'\in\data.nnd');
     writeln(F, StructureEditorPath+'\in\data.iel');
     writeln(F, StructureEditorPath+'\in\data.mt0');
     writeln(F, StructureEditorPath+'\in\data.tr0');
     writeln(F, StructureEditorPath+'\out\data.plr');
     CloseFile(F);
    //run the analyze program to generate the out put files
     ShellExecute(MainControlForm.Handle, 'open',
                  PChar('dumAnalyze.exe'),
                  nil,
                  PChar(StructureEditorPath+'\Analyze\'),
                  SW_SHOWNA );
  end;{if AnalyzingMode}
end;{procedure AnalyzeModeMenuItemClick}

procedure TMainControlForm.PressureMenuItemLV2Click(Sender: TObject);
begin
  //decide which MultiFcnData to display
   SelectedMultiFcnData:= 1;
  //let AnalyzeResultViewer show the result
   AnalyzeResultViewerForm.Visible:= true;
   AnalyzeResultViewerForm.ReloadMenuItemClick(nil);
end;

procedure TMainControlForm.EnergyMenuItemLV2Click(Sender: TObject);
begin
  //decide which MultiFcnData to display
   SelectedMultiFcnData:= 2;
  //let AnalyzeResultViewer show the result
   AnalyzeResultViewerForm.Visible:= true;
   AnalyzeResultViewerForm.ReloadMenuItemClick(nil);
end;

procedure TMainControlForm.AboutStructureEditorMenuItemClick(Sender: TObject);
begin
  ShowMessage( 'StructureEditor Build 3'
              +#13
              +#13+'Copyright: 2003 Dr.D.F.Stolle'
              +#13+'Department of Civil Engineering'
              +#13+'McMaster University');
end; {procedure AboutStructureEditorMenuItemClick}

procedure TMainControlForm.StructureEditorHelpMenuItemClick(
  Sender: TObject);
begin
  ShellExecute(MainControlForm.Handle, 'open',
                  PChar('SEMenu1p0beta.doc'),
                  nil,
                  PChar(StructureEditorPath+'\SEhelp\'),
                  SW_SHOWNA );
end;

end.
