unit AnalyzeLib;

interface
uses
  Sysutils, ConvLib;

type

  TNode=record
    X,Y: real;
    iu,iv: integer;
  end;

  TIEL=record
    V1,V3,V5,V2,V4,V6,Material: integer;
  end;

  T1DFloats = array of real;
  T2DFloats = array of T1DFloats;
  
var
  Nodes: array of TNode;
  IEL: array of TIEL;
  MultiFcnData: T2DFloats;
  SelectedMultiFcnData: integer;

function GetNumTextRow(PathNameExt: string): integer;
function GetNumTextCol(PathNameExt: string): integer;
procedure ielBuild(PathNameExt: string);
procedure nndBuild(PathNameExt: string);
procedure mtlBuild(PathNameExt: string);
procedure trcBuild(PathNameExt: string);
procedure LoadNodes(PathNameExt: string);
procedure LoadIEL(PathNameExt: string);
procedure Load2DFloats(PathNameExt: string;
                       var A: T2DFloats);

implementation

type
  TuvRestrictedUNS=record
    iu, iv: integer;
  end;

var
  uvRestrictedUNS: array of TuvRestrictedUNS;

procedure Free2DFloats(var A: T2DFloats);
var i, l: integer;
begin
  l:= length(A);
  for i:= 1 to l do begin
    A[i-1]:= nil;
  end;{for}
  A:= nil;
end; {procedure Free2DFloats}

procedure Load2DFloats(PathNameExt: string;
                       var A: T2DFloats);
{assumption:1) PathNameExt is a file name with full path and extension
            2) every rows of the file indicated by PathNameExt have
               the same number of numbers, all characters in the text
               file are numeric characters or spaces
 post: (the number ith row and jth column)=A[i-1][j-1] }
var
  F: TextFile;
  c,r, i,j :integer;
begin
  r:= GetNumTextRow(PathNameExt);
  c:= GetNumTextCol(PathNameExt);
  //open file
  AssignFile(F, PathNameExt);
  //initialize A
  SetLength(A, r);
  for i:= 1 to r do begin
    SetLength(A[i-1],c);
  end;{for 1 to number of rows}
  //assign A
  reset(F);
  for i:= 1 to r do begin
    for j:= 1 to c do begin
      read(F, (A[i-1])[j-1]);
    end;{for 1 to number of columns}
    readln(F);
  end;{for 1 to number of rows}
  //finish
  CloseFile(F);
end; {procedure Load2DFloats}

procedure MakeRestrictedUNS;
var
  i,j,nn,nk,nseq: integer;
begin
  nn:= length(UNodeS);
  nk:= length(KinmatBoundary);
 //initialize uvRestrictedUNS
  SetLength(uvRestrictedUNS, nn);
  for i:= 1 to nn do begin
    uvRestrictedUNS[i-1].iu:= 1;
    uvRestrictedUNS[i-1].iv:= 1;
  end;{for 1 to length of uvRestrictedUNS}
 //assign uvRestrictedUNS
  for i:= 1 to nk do begin
    nseq:= length(KinmatBoundary[i-1].SSequence);
    for j:= 1 to nseq do begin
      uvRestrictedUNS[KinmatBoundary[i-1].SSequence[j-1]-1].iu:=
        KinmatValue[i-1].iu;
      uvRestrictedUNS[KinmatBoundary[i-1].SSequence[j-1]-1].iv:=
        KinmatValue[i-1].iv;
    end;{for 1 to length of SSequence}
  end;{for 1 to length of kinmat boundary}
end;{procedure MakeRestrictedUNS}

procedure LoadNodes(PathNameExt: string);
{assumption: .nnd file is in the ready in the appropriate folder
 post: array Nodes is assigned}
var
  F: TextFile;
  i, n: integer;
begin
  //get the length of array Nodes
  n:= GetNumTextRow(PathNameExt);
  //openfile
  AssignFile(F, PathNameExt);
  //assign the array Nodes
  SetLength(Nodes, n);
  reset(F);
  for i:= 1 to n do begin
    readln(F, Nodes[i-1].X, Nodes[i-1].Y, Nodes[i-1].iu, Nodes[i-1].iv);
  end;{for}
  //finish
  CloseFile(F);
end;{procedure LoadNodes}

procedure LoadIEL(PathNameExt: string);
var
  F: TextFile;
  i, n: integer;
begin
  //get the length of array Nodes
  n:= GetNumTextRow(PathNameExt);
  //open file
  AssignFile(F, PathNameExt);
  //assign the array IEL
  SetLength(IEL,n);
  reset(F);
  for i:= 1 to n do begin
    readln(F, IEL[i-1].V1, IEL[i-1].V3, IEL[i-1].V5,
              IEL[i-1].V2, IEL[i-1].V4, IEL[i-1].V6,
              IEL[i-1].Material );
  end;{for}
  //finish
  CloseFile(F);
end;{procedure LoadIEL}

function GetNumTextCol(PathNameExt: string): integer;
{assumption: PathNameExt is a valid file name with full path and
             extension
 post: check the first line of PathNameExt and see how many continuous
       non-space blocks it has }
var
  F: TextFile;
  ans: integer;
  last, curr: char;
begin
  AssignFile(F, PathNameExt);
  reset(F);
  ans:= 0;
  last:= ' ';
  while not eoln(F) do begin
    read(F, curr);
    if (last=' ') and (curr<>' ') then begin
      ans:= ans+1;
    end;{if}
    last:= curr;
  end;{while}
  GetNumTextCol:= ans;
  CloseFile(F);
end;{function GetNumTextCol}

function GetNumTextRow(PathNameExt: string): integer;
{assumption: PathNameExt is a valid file name with full path and
             extension
 post: count how many lines there are in the text file before the first
       empty line. ematy line means the length of this line is zero }
var
  F: TextFile;
  ans: integer;
  tmpString: string;
begin
  AssignFile(F, PathNameExt);
  reset(F);
  ans:= 0;
  readln(F, tmpString);
  while tmpString<>'' do begin
    ans:= ans+1;
    readln(F, tmpString);
  end;{while}
  GetNumTextRow:= ans;
  CloseFile(F);
end;{function GetNumTextCol}

procedure ielBuild(PathNameExt: string);
{assumption: a structure is loaded}
var
  F: TextFile;
  i,l: integer;
  FormatString: string;
begin
  AssignFile(F, PathNameExt);
  rewrite(F);
  l:= length(DSubElementS);
  for i:= 1 to l do begin
    FormatString:=
      format('%5d %5d %5d %5d %5d %5d %5d',
             [ SNUDmap[USubElementS[DSubElementS[i-1]-1].V1-1],
               SNUDmap[USubElementS[DSubElementS[i-1]-1].V3-1],
               SNUDmap[USubElementS[DSubElementS[i-1]-1].V5-1],
               SNUDmap[USubElementS[DSubElementS[i-1]-1].V2-1],
               SNUDmap[USubElementS[DSubElementS[i-1]-1].V4-1],
               SNUDmap[USubElementS[DSubElementS[i-1]-1].V6-1],
               GetSubElementMaterial(DSubElementS[i-1]) ] );
    writeln(F, FormatString);
  end;{for i}
  CloseFile(F);
end;{procedure ielBuild}

procedure nndBuild(PathNameExt: string);
{assumption: a structure is loaded}
var
  F: TextFile;
  i,l: integer;
  FormatString: string;
begin
 //build the pre-requested data structure
  MakeRestrictedUNS;
 //make the file
  AssignFile(F, PathNameExt);
  rewrite(F);
  l:= length(DNodeS);
  for i:= 1 to l do begin
    FormatString:=
      format('%-10e %-10e %1d %1d',
             [ UNodeS[DNodeS[i-1]-1].ShapedX,
               UNodeS[DNodeS[i-1]-1].ShapedY,
               uvRestrictedUNS[DNodeS[i-1]-1].iu,
               uvRestrictedUNS[DNodeS[i-1]-1].iv ] );
    writeln(F, FormatString); 
  end;
  CloseFile(F);
end;{procedure nndBuild}

procedure mtlBuild(PathNameExt: string);
begin
  {reserved}
end;

procedure trcBuild(PathNameExt: string);
begin
  {reserved}
end;

end.
