function test_gen(ds,name_gen)

cont.randompick = 1;
cont.enumstretch = 1;

timeLimit = 900;

for d = ds
    
    time_summary = [];
    iter_summary = [];
    
    record.randompick = {};
    record.enumstretch = {};
 
    NumCase = 1000;
    
    fprintf(['d = ' num2str(d) '   ']);
    NumBack=0;
    
    for i = 1:NumCase
        
        for c=1:NumBack
            fprintf('\b');
        end
        NumBack = fprintf('i = %d', i);

        [Pts,ColorPartition,b]=feval(name_gen,d);
        
        if cont.randompick
            [x,info]=cfp_solver_randompick(Pts,b,ColorPartition);
            record.randompick{i}=info;
        end
        
        if cont.enumstretch
            [x,info]=cfp_solver_enumstretch(Pts,b,ColorPartition);
            record.enumstretch{i}=info;
        end

    end
    

    if cont.randompick
        iter_summary.randompick = get_iter_summary(record, 'randompick');
        time_summary.randompick = get_time_summary(record, 'randompick');
        cont.randompick = ...
            ((time_summary.randompick.total...
            /time_summary.randompick.validcases)<timeLimit);
    end

    if cont.enumstretch
        iter_summary.enumstretch = get_iter_summary(record, 'enumstretch');
        time_summary.enumstretch = get_time_summary(record, 'enumstretch');
        cont.enumstretch = ...
            ((time_summary.enumstretch.total...
            /time_summary.enumstretch.validcases)<timeLimit);
    end
    
    save(['results/' name_gen num2str(d) 'd.mat'], ...
        'record', 'iter_summary', 'time_summary');
    
    fprintf('\n');

end
    
end

function summary = get_iter_summary(record, name_solver)

infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.total = 0;
summary.validcases = 0;
summary.max = 0;
summary.min = Inf;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible == 1)
        summary.validcases = summary.validcases + 1;
        summary.total = summary.total + info.iter;
        if (info.iter>summary.max)
            summary.max = info.iter;
        end
        if info.iter<summary.min
            summary.min = info.iter;
        end
    end
end

end


function summary = get_time_summary(record, name_solver)

infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.total = 0;
summary.validcases = 0;
summary.max = 0;
summary.min = Inf;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible == 1)
        summary.validcases = summary.validcases + 1;
        summary.total = summary.total + info.time;
        if (info.time>summary.max)
            summary.max = info.time;
        end
        if info.time<summary.min
            summary.min = info.time;
        end
    end
end

end

function [Pts,Partition,b]=cfp_gencore_tube_balanced(d)
[Pts,Partition,b]=cfp_gencore_tube(d,pi/6,0);
end

function [Pts,Partition,b]=cfp_gencore_tube_unbalanced(d)
[Pts,Partition,b]=cfp_gencore_tube(d,pi/6,1);
end