function r = rand_int(m,n,rg);
%
% Generate integer/integers between rg(1) and rg(2), inclusively.
% 
% **********
% * Syntax *
% **********
% r = rand_int(m,n,rg)
%
% *******************
% * Input Arguments *
% *******************
% m and n are the height and width of the output matrix.
%   rg is a two element vector specifying the range of the random
% integer/integers to be generated, inclusively. rg(1)<=rg(2) must be
% satisfied.
%
% ********************
% * Output Arguments *
% ********************
% r is the m by n matrix of random integers between rg(1) and rg(2).
%
% See also: RAND_REAL

%%%%%%%%%%%%%%%%%%%%%%%%% Internal Comments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Written by Sui Huang, Advanced Optimization Lab, McMaster University,
% Hamilton, Ontario, Canada.
% 
% ************************
% * Modification History *
% ************************
% May  2005: First version.
% July 2005: Added comments.
% 


r = rg(1)*ones(m,n);
diff = rg(2)-rg(1) + 0.99999;
r = r + floor(rand(m,n)*diff);

return