function s = accsum(v)
% Accurate summation reducing numerical error.
% Input      : v is a vector.
% Output     : s is the sum of elements in v.
% Description:
%   A critical case numerical error is sum([1 1e-10 1e-10 ... 1e-10]) may
%   return only 1, discarding all elements after the first. This routine
%   can reduce the error caused by these kind of cases.
%     The draw back is that it increase the complexity from O(n) to
%   O(nlgn).
posv = sort(v(v>=0),'ascend');
negv = sort(v(v<0) ,'descend');
s = sum(posv)+sum(negv);
return